/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PaymentOp
implements XdrElement {
    private MuxedAccount destination;
    private Asset asset;
    private Int64 amount;

    public MuxedAccount getDestination() {
        return this.destination;
    }

    public void setDestination(MuxedAccount value) {
        this.destination = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public static void encode(XdrDataOutputStream stream, PaymentOp encodedPaymentOp) throws IOException {
        MuxedAccount.encode(stream, encodedPaymentOp.destination);
        Asset.encode(stream, encodedPaymentOp.asset);
        Int64.encode(stream, encodedPaymentOp.amount);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PaymentOp.encode(stream, this);
    }

    public static PaymentOp decode(XdrDataInputStream stream) throws IOException {
        PaymentOp decodedPaymentOp = new PaymentOp();
        decodedPaymentOp.destination = MuxedAccount.decode(stream);
        decodedPaymentOp.asset = Asset.decode(stream);
        decodedPaymentOp.amount = Int64.decode(stream);
        return decodedPaymentOp;
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.asset, this.amount);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaymentOp)) {
            return false;
        }
        PaymentOp other = (PaymentOp)object;
        return Objects.equals(this.destination, other.destination) && Objects.equals(this.asset, other.asset) && Objects.equals(this.amount, other.amount);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PaymentOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PaymentOp.fromXdrByteArray(bytes);
    }

    public static PaymentOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PaymentOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private MuxedAccount destination;
        private Asset asset;
        private Int64 amount;

        public Builder destination(MuxedAccount destination) {
            this.destination = destination;
            return this;
        }

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public PaymentOp build() {
            PaymentOp val = new PaymentOp();
            val.setDestination(this.destination);
            val.setAsset(this.asset);
            val.setAmount(this.amount);
            return val;
        }
    }
}

