/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PersistedSCPStateV0;
import org.stellar.sdk.xdr.PersistedSCPStateV1;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PersistedSCPState
implements XdrElement {
    Integer v;
    private PersistedSCPStateV0 v0;
    private PersistedSCPStateV1 v1;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public PersistedSCPStateV0 getV0() {
        return this.v0;
    }

    public void setV0(PersistedSCPStateV0 value) {
        this.v0 = value;
    }

    public PersistedSCPStateV1 getV1() {
        return this.v1;
    }

    public void setV1(PersistedSCPStateV1 value) {
        this.v1 = value;
    }

    public static void encode(XdrDataOutputStream stream, PersistedSCPState encodedPersistedSCPState) throws IOException {
        stream.writeInt(encodedPersistedSCPState.getDiscriminant());
        switch (encodedPersistedSCPState.getDiscriminant()) {
            case 0: {
                PersistedSCPStateV0.encode(stream, encodedPersistedSCPState.v0);
                break;
            }
            case 1: {
                PersistedSCPStateV1.encode(stream, encodedPersistedSCPState.v1);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PersistedSCPState.encode(stream, this);
    }

    public static PersistedSCPState decode(XdrDataInputStream stream) throws IOException {
        PersistedSCPState decodedPersistedSCPState = new PersistedSCPState();
        Integer discriminant = stream.readInt();
        decodedPersistedSCPState.setDiscriminant(discriminant);
        switch (decodedPersistedSCPState.getDiscriminant()) {
            case 0: {
                decodedPersistedSCPState.v0 = PersistedSCPStateV0.decode(stream);
                break;
            }
            case 1: {
                decodedPersistedSCPState.v1 = PersistedSCPStateV1.decode(stream);
            }
        }
        return decodedPersistedSCPState;
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.v1, this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PersistedSCPState)) {
            return false;
        }
        PersistedSCPState other = (PersistedSCPState)object;
        return Objects.equals(this.v0, other.v0) && Objects.equals(this.v1, other.v1) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PersistedSCPState fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PersistedSCPState.fromXdrByteArray(bytes);
    }

    public static PersistedSCPState fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PersistedSCPState.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer discriminant;
        private PersistedSCPStateV0 v0;
        private PersistedSCPStateV1 v1;

        public Builder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(PersistedSCPStateV0 v0) {
            this.v0 = v0;
            return this;
        }

        public Builder v1(PersistedSCPStateV1 v1) {
            this.v1 = v1;
            return this;
        }

        public PersistedSCPState build() {
            PersistedSCPState val = new PersistedSCPState();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            val.setV1(this.v1);
            return val;
        }
    }
}

