/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.LedgerBounds;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PreconditionsV2
implements XdrElement {
    private TimeBounds timeBounds;
    private LedgerBounds ledgerBounds;
    private SequenceNumber minSeqNum;
    private Duration minSeqAge;
    private Uint32 minSeqLedgerGap;
    private SignerKey[] extraSigners;

    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    public void setTimeBounds(TimeBounds value) {
        this.timeBounds = value;
    }

    public LedgerBounds getLedgerBounds() {
        return this.ledgerBounds;
    }

    public void setLedgerBounds(LedgerBounds value) {
        this.ledgerBounds = value;
    }

    public SequenceNumber getMinSeqNum() {
        return this.minSeqNum;
    }

    public void setMinSeqNum(SequenceNumber value) {
        this.minSeqNum = value;
    }

    public Duration getMinSeqAge() {
        return this.minSeqAge;
    }

    public void setMinSeqAge(Duration value) {
        this.minSeqAge = value;
    }

    public Uint32 getMinSeqLedgerGap() {
        return this.minSeqLedgerGap;
    }

    public void setMinSeqLedgerGap(Uint32 value) {
        this.minSeqLedgerGap = value;
    }

    public SignerKey[] getExtraSigners() {
        return this.extraSigners;
    }

    public void setExtraSigners(SignerKey[] value) {
        this.extraSigners = value;
    }

    public static void encode(XdrDataOutputStream stream, PreconditionsV2 encodedPreconditionsV2) throws IOException {
        if (encodedPreconditionsV2.timeBounds != null) {
            stream.writeInt(1);
            TimeBounds.encode(stream, encodedPreconditionsV2.timeBounds);
        } else {
            stream.writeInt(0);
        }
        if (encodedPreconditionsV2.ledgerBounds != null) {
            stream.writeInt(1);
            LedgerBounds.encode(stream, encodedPreconditionsV2.ledgerBounds);
        } else {
            stream.writeInt(0);
        }
        if (encodedPreconditionsV2.minSeqNum != null) {
            stream.writeInt(1);
            SequenceNumber.encode(stream, encodedPreconditionsV2.minSeqNum);
        } else {
            stream.writeInt(0);
        }
        Duration.encode(stream, encodedPreconditionsV2.minSeqAge);
        Uint32.encode(stream, encodedPreconditionsV2.minSeqLedgerGap);
        int extraSignerssize = encodedPreconditionsV2.getExtraSigners().length;
        stream.writeInt(extraSignerssize);
        for (int i = 0; i < extraSignerssize; ++i) {
            SignerKey.encode(stream, encodedPreconditionsV2.extraSigners[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PreconditionsV2.encode(stream, this);
    }

    public static PreconditionsV2 decode(XdrDataInputStream stream) throws IOException {
        int minSeqNumPresent;
        int ledgerBoundsPresent;
        PreconditionsV2 decodedPreconditionsV2 = new PreconditionsV2();
        int timeBoundsPresent = stream.readInt();
        if (timeBoundsPresent != 0) {
            decodedPreconditionsV2.timeBounds = TimeBounds.decode(stream);
        }
        if ((ledgerBoundsPresent = stream.readInt()) != 0) {
            decodedPreconditionsV2.ledgerBounds = LedgerBounds.decode(stream);
        }
        if ((minSeqNumPresent = stream.readInt()) != 0) {
            decodedPreconditionsV2.minSeqNum = SequenceNumber.decode(stream);
        }
        decodedPreconditionsV2.minSeqAge = Duration.decode(stream);
        decodedPreconditionsV2.minSeqLedgerGap = Uint32.decode(stream);
        int extraSignerssize = stream.readInt();
        decodedPreconditionsV2.extraSigners = new SignerKey[extraSignerssize];
        for (int i = 0; i < extraSignerssize; ++i) {
            decodedPreconditionsV2.extraSigners[i] = SignerKey.decode(stream);
        }
        return decodedPreconditionsV2;
    }

    public int hashCode() {
        return Objects.hash(this.timeBounds, this.ledgerBounds, this.minSeqNum, this.minSeqAge, this.minSeqLedgerGap, Arrays.hashCode(this.extraSigners));
    }

    public boolean equals(Object object) {
        if (!(object instanceof PreconditionsV2)) {
            return false;
        }
        PreconditionsV2 other = (PreconditionsV2)object;
        return Objects.equals(this.timeBounds, other.timeBounds) && Objects.equals(this.ledgerBounds, other.ledgerBounds) && Objects.equals(this.minSeqNum, other.minSeqNum) && Objects.equals(this.minSeqAge, other.minSeqAge) && Objects.equals(this.minSeqLedgerGap, other.minSeqLedgerGap) && Arrays.equals(this.extraSigners, other.extraSigners);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PreconditionsV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PreconditionsV2.fromXdrByteArray(bytes);
    }

    public static PreconditionsV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PreconditionsV2.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private TimeBounds timeBounds;
        private LedgerBounds ledgerBounds;
        private SequenceNumber minSeqNum;
        private Duration minSeqAge;
        private Uint32 minSeqLedgerGap;
        private SignerKey[] extraSigners;

        public Builder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        public Builder ledgerBounds(LedgerBounds ledgerBounds) {
            this.ledgerBounds = ledgerBounds;
            return this;
        }

        public Builder minSeqNum(SequenceNumber minSeqNum) {
            this.minSeqNum = minSeqNum;
            return this;
        }

        public Builder minSeqAge(Duration minSeqAge) {
            this.minSeqAge = minSeqAge;
            return this;
        }

        public Builder minSeqLedgerGap(Uint32 minSeqLedgerGap) {
            this.minSeqLedgerGap = minSeqLedgerGap;
            return this;
        }

        public Builder extraSigners(SignerKey[] extraSigners) {
            this.extraSigners = extraSigners;
            return this;
        }

        public PreconditionsV2 build() {
            PreconditionsV2 val = new PreconditionsV2();
            val.setTimeBounds(this.timeBounds);
            val.setLedgerBounds(this.ledgerBounds);
            val.setMinSeqNum(this.minSeqNum);
            val.setMinSeqAge(this.minSeqAge);
            val.setMinSeqLedgerGap(this.minSeqLedgerGap);
            val.setExtraSigners(this.extraSigners);
            return val;
        }
    }
}

