/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCErrorType implements XdrElement
{
    SCE_CONTRACT(0),
    SCE_WASM_VM(1),
    SCE_CONTEXT(2),
    SCE_STORAGE(3),
    SCE_OBJECT(4),
    SCE_CRYPTO(5),
    SCE_EVENTS(6),
    SCE_BUDGET(7),
    SCE_VALUE(8),
    SCE_AUTH(9);

    private int mValue;

    private SCErrorType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SCErrorType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SCE_CONTRACT;
            }
            case 1: {
                return SCE_WASM_VM;
            }
            case 2: {
                return SCE_CONTEXT;
            }
            case 3: {
                return SCE_STORAGE;
            }
            case 4: {
                return SCE_OBJECT;
            }
            case 5: {
                return SCE_CRYPTO;
            }
            case 6: {
                return SCE_EVENTS;
            }
            case 7: {
                return SCE_BUDGET;
            }
            case 8: {
                return SCE_VALUE;
            }
            case 9: {
                return SCE_AUTH;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SCErrorType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCErrorType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCErrorType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCErrorType.fromXdrByteArray(bytes);
    }

    public static SCErrorType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCErrorType.decode(xdrDataInputStream);
    }
}

