/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCMapEntry
implements XdrElement {
    private SCVal key;
    private SCVal val;

    public SCVal getKey() {
        return this.key;
    }

    public void setKey(SCVal value) {
        this.key = value;
    }

    public SCVal getVal() {
        return this.val;
    }

    public void setVal(SCVal value) {
        this.val = value;
    }

    public static void encode(XdrDataOutputStream stream, SCMapEntry encodedSCMapEntry) throws IOException {
        SCVal.encode(stream, encodedSCMapEntry.key);
        SCVal.encode(stream, encodedSCMapEntry.val);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCMapEntry.encode(stream, this);
    }

    public static SCMapEntry decode(XdrDataInputStream stream) throws IOException {
        SCMapEntry decodedSCMapEntry = new SCMapEntry();
        decodedSCMapEntry.key = SCVal.decode(stream);
        decodedSCMapEntry.val = SCVal.decode(stream);
        return decodedSCMapEntry;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.val);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCMapEntry)) {
            return false;
        }
        SCMapEntry other = (SCMapEntry)object;
        return Objects.equals(this.key, other.key) && Objects.equals(this.val, other.val);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCMapEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCMapEntry.fromXdrByteArray(bytes);
    }

    public static SCMapEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCMapEntry.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCVal key;
        private SCVal val;

        public Builder key(SCVal key) {
            this.key = key;
            return this;
        }

        public Builder val(SCVal val) {
            this.val = val;
            return this;
        }

        public SCMapEntry build() {
            SCMapEntry val = new SCMapEntry();
            val.setKey(this.key);
            val.setVal(this.val);
            return val;
        }
    }
}

