/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCMetaKind;
import org.stellar.sdk.xdr.SCMetaV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCMetaEntry
implements XdrElement {
    SCMetaKind kind;
    private SCMetaV0 v0;

    public SCMetaKind getDiscriminant() {
        return this.kind;
    }

    public void setDiscriminant(SCMetaKind value) {
        this.kind = value;
    }

    public SCMetaV0 getV0() {
        return this.v0;
    }

    public void setV0(SCMetaV0 value) {
        this.v0 = value;
    }

    public static void encode(XdrDataOutputStream stream, SCMetaEntry encodedSCMetaEntry) throws IOException {
        stream.writeInt(encodedSCMetaEntry.getDiscriminant().getValue());
        switch (encodedSCMetaEntry.getDiscriminant()) {
            case SC_META_V0: {
                SCMetaV0.encode(stream, encodedSCMetaEntry.v0);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCMetaEntry.encode(stream, this);
    }

    public static SCMetaEntry decode(XdrDataInputStream stream) throws IOException {
        SCMetaEntry decodedSCMetaEntry = new SCMetaEntry();
        SCMetaKind discriminant = SCMetaKind.decode(stream);
        decodedSCMetaEntry.setDiscriminant(discriminant);
        switch (decodedSCMetaEntry.getDiscriminant()) {
            case SC_META_V0: {
                decodedSCMetaEntry.v0 = SCMetaV0.decode(stream);
            }
        }
        return decodedSCMetaEntry;
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.kind);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCMetaEntry)) {
            return false;
        }
        SCMetaEntry other = (SCMetaEntry)object;
        return Objects.equals(this.v0, other.v0) && Objects.equals(this.kind, other.kind);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCMetaEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCMetaEntry.fromXdrByteArray(bytes);
    }

    public static SCMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCMetaEntry.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCMetaKind discriminant;
        private SCMetaV0 v0;

        public Builder discriminant(SCMetaKind discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(SCMetaV0 v0) {
            this.v0 = v0;
            return this;
        }

        public SCMetaEntry build() {
            SCMetaEntry val = new SCMetaEntry();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            return val;
        }
    }
}

