/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCSpecTypeTuple
implements XdrElement {
    private SCSpecTypeDef[] valueTypes;

    public SCSpecTypeDef[] getValueTypes() {
        return this.valueTypes;
    }

    public void setValueTypes(SCSpecTypeDef[] value) {
        this.valueTypes = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecTypeTuple encodedSCSpecTypeTuple) throws IOException {
        int valueTypessize = encodedSCSpecTypeTuple.getValueTypes().length;
        stream.writeInt(valueTypessize);
        for (int i = 0; i < valueTypessize; ++i) {
            SCSpecTypeDef.encode(stream, encodedSCSpecTypeTuple.valueTypes[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecTypeTuple.encode(stream, this);
    }

    public static SCSpecTypeTuple decode(XdrDataInputStream stream) throws IOException {
        SCSpecTypeTuple decodedSCSpecTypeTuple = new SCSpecTypeTuple();
        int valueTypessize = stream.readInt();
        decodedSCSpecTypeTuple.valueTypes = new SCSpecTypeDef[valueTypessize];
        for (int i = 0; i < valueTypessize; ++i) {
            decodedSCSpecTypeTuple.valueTypes[i] = SCSpecTypeDef.decode(stream);
        }
        return decodedSCSpecTypeTuple;
    }

    public int hashCode() {
        return Arrays.hashCode(this.valueTypes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecTypeTuple)) {
            return false;
        }
        SCSpecTypeTuple other = (SCSpecTypeTuple)object;
        return Arrays.equals(this.valueTypes, other.valueTypes);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecTypeTuple fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecTypeTuple.fromXdrByteArray(bytes);
    }

    public static SCSpecTypeTuple fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecTypeTuple.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCSpecTypeDef[] valueTypes;

        public Builder valueTypes(SCSpecTypeDef[] valueTypes) {
            this.valueTypes = valueTypes;
            return this;
        }

        public SCSpecTypeTuple build() {
            SCSpecTypeTuple val = new SCSpecTypeTuple();
            val.setValueTypes(this.valueTypes);
            return val;
        }
    }
}

