/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecUDTUnionCaseTupleV0
implements XdrElement {
    private XdrString doc;
    private XdrString name;
    private SCSpecTypeDef[] type;

    public XdrString getDoc() {
        return this.doc;
    }

    public void setDoc(XdrString value) {
        this.doc = value;
    }

    public XdrString getName() {
        return this.name;
    }

    public void setName(XdrString value) {
        this.name = value;
    }

    public SCSpecTypeDef[] getType() {
        return this.type;
    }

    public void setType(SCSpecTypeDef[] value) {
        this.type = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecUDTUnionCaseTupleV0 encodedSCSpecUDTUnionCaseTupleV0) throws IOException {
        encodedSCSpecUDTUnionCaseTupleV0.doc.encode(stream);
        encodedSCSpecUDTUnionCaseTupleV0.name.encode(stream);
        int typesize = encodedSCSpecUDTUnionCaseTupleV0.getType().length;
        stream.writeInt(typesize);
        for (int i = 0; i < typesize; ++i) {
            SCSpecTypeDef.encode(stream, encodedSCSpecUDTUnionCaseTupleV0.type[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecUDTUnionCaseTupleV0.encode(stream, this);
    }

    public static SCSpecUDTUnionCaseTupleV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecUDTUnionCaseTupleV0 decodedSCSpecUDTUnionCaseTupleV0 = new SCSpecUDTUnionCaseTupleV0();
        decodedSCSpecUDTUnionCaseTupleV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecUDTUnionCaseTupleV0.name = XdrString.decode(stream, 60);
        int typesize = stream.readInt();
        decodedSCSpecUDTUnionCaseTupleV0.type = new SCSpecTypeDef[typesize];
        for (int i = 0; i < typesize; ++i) {
            decodedSCSpecUDTUnionCaseTupleV0.type[i] = SCSpecTypeDef.decode(stream);
        }
        return decodedSCSpecUDTUnionCaseTupleV0;
    }

    public int hashCode() {
        return Objects.hash(this.doc, this.name, Arrays.hashCode(this.type));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecUDTUnionCaseTupleV0)) {
            return false;
        }
        SCSpecUDTUnionCaseTupleV0 other = (SCSpecUDTUnionCaseTupleV0)object;
        return Objects.equals(this.doc, other.doc) && Objects.equals(this.name, other.name) && Arrays.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecUDTUnionCaseTupleV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecUDTUnionCaseTupleV0.fromXdrByteArray(bytes);
    }

    public static SCSpecUDTUnionCaseTupleV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecUDTUnionCaseTupleV0.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private XdrString doc;
        private XdrString name;
        private SCSpecTypeDef[] type;

        public Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        public Builder name(XdrString name) {
            this.name = name;
            return this;
        }

        public Builder type(SCSpecTypeDef[] type) {
            this.type = type;
            return this;
        }

        public SCSpecUDTUnionCaseTupleV0 build() {
            SCSpecUDTUnionCaseTupleV0 val = new SCSpecUDTUnionCaseTupleV0();
            val.setDoc(this.doc);
            val.setName(this.name);
            val.setType(this.type);
            return val;
        }
    }
}

