/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Signer;
import org.stellar.sdk.xdr.String32;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SetOptionsOp
implements XdrElement {
    private AccountID inflationDest;
    private Uint32 clearFlags;
    private Uint32 setFlags;
    private Uint32 masterWeight;
    private Uint32 lowThreshold;
    private Uint32 medThreshold;
    private Uint32 highThreshold;
    private String32 homeDomain;
    private Signer signer;

    public AccountID getInflationDest() {
        return this.inflationDest;
    }

    public void setInflationDest(AccountID value) {
        this.inflationDest = value;
    }

    public Uint32 getClearFlags() {
        return this.clearFlags;
    }

    public void setClearFlags(Uint32 value) {
        this.clearFlags = value;
    }

    public Uint32 getSetFlags() {
        return this.setFlags;
    }

    public void setSetFlags(Uint32 value) {
        this.setFlags = value;
    }

    public Uint32 getMasterWeight() {
        return this.masterWeight;
    }

    public void setMasterWeight(Uint32 value) {
        this.masterWeight = value;
    }

    public Uint32 getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(Uint32 value) {
        this.lowThreshold = value;
    }

    public Uint32 getMedThreshold() {
        return this.medThreshold;
    }

    public void setMedThreshold(Uint32 value) {
        this.medThreshold = value;
    }

    public Uint32 getHighThreshold() {
        return this.highThreshold;
    }

    public void setHighThreshold(Uint32 value) {
        this.highThreshold = value;
    }

    public String32 getHomeDomain() {
        return this.homeDomain;
    }

    public void setHomeDomain(String32 value) {
        this.homeDomain = value;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public void setSigner(Signer value) {
        this.signer = value;
    }

    public static void encode(XdrDataOutputStream stream, SetOptionsOp encodedSetOptionsOp) throws IOException {
        if (encodedSetOptionsOp.inflationDest != null) {
            stream.writeInt(1);
            AccountID.encode(stream, encodedSetOptionsOp.inflationDest);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.clearFlags != null) {
            stream.writeInt(1);
            Uint32.encode(stream, encodedSetOptionsOp.clearFlags);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.setFlags != null) {
            stream.writeInt(1);
            Uint32.encode(stream, encodedSetOptionsOp.setFlags);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.masterWeight != null) {
            stream.writeInt(1);
            Uint32.encode(stream, encodedSetOptionsOp.masterWeight);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.lowThreshold != null) {
            stream.writeInt(1);
            Uint32.encode(stream, encodedSetOptionsOp.lowThreshold);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.medThreshold != null) {
            stream.writeInt(1);
            Uint32.encode(stream, encodedSetOptionsOp.medThreshold);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.highThreshold != null) {
            stream.writeInt(1);
            Uint32.encode(stream, encodedSetOptionsOp.highThreshold);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.homeDomain != null) {
            stream.writeInt(1);
            String32.encode(stream, encodedSetOptionsOp.homeDomain);
        } else {
            stream.writeInt(0);
        }
        if (encodedSetOptionsOp.signer != null) {
            stream.writeInt(1);
            Signer.encode(stream, encodedSetOptionsOp.signer);
        } else {
            stream.writeInt(0);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SetOptionsOp.encode(stream, this);
    }

    public static SetOptionsOp decode(XdrDataInputStream stream) throws IOException {
        int signerPresent;
        int homeDomainPresent;
        int highThresholdPresent;
        int medThresholdPresent;
        int lowThresholdPresent;
        int masterWeightPresent;
        int setFlagsPresent;
        int clearFlagsPresent;
        SetOptionsOp decodedSetOptionsOp = new SetOptionsOp();
        int inflationDestPresent = stream.readInt();
        if (inflationDestPresent != 0) {
            decodedSetOptionsOp.inflationDest = AccountID.decode(stream);
        }
        if ((clearFlagsPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.clearFlags = Uint32.decode(stream);
        }
        if ((setFlagsPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.setFlags = Uint32.decode(stream);
        }
        if ((masterWeightPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.masterWeight = Uint32.decode(stream);
        }
        if ((lowThresholdPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.lowThreshold = Uint32.decode(stream);
        }
        if ((medThresholdPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.medThreshold = Uint32.decode(stream);
        }
        if ((highThresholdPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.highThreshold = Uint32.decode(stream);
        }
        if ((homeDomainPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.homeDomain = String32.decode(stream);
        }
        if ((signerPresent = stream.readInt()) != 0) {
            decodedSetOptionsOp.signer = Signer.decode(stream);
        }
        return decodedSetOptionsOp;
    }

    public int hashCode() {
        return Objects.hash(this.inflationDest, this.clearFlags, this.setFlags, this.masterWeight, this.lowThreshold, this.medThreshold, this.highThreshold, this.homeDomain, this.signer);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SetOptionsOp)) {
            return false;
        }
        SetOptionsOp other = (SetOptionsOp)object;
        return Objects.equals(this.inflationDest, other.inflationDest) && Objects.equals(this.clearFlags, other.clearFlags) && Objects.equals(this.setFlags, other.setFlags) && Objects.equals(this.masterWeight, other.masterWeight) && Objects.equals(this.lowThreshold, other.lowThreshold) && Objects.equals(this.medThreshold, other.medThreshold) && Objects.equals(this.highThreshold, other.highThreshold) && Objects.equals(this.homeDomain, other.homeDomain) && Objects.equals(this.signer, other.signer);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SetOptionsOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SetOptionsOp.fromXdrByteArray(bytes);
    }

    public static SetOptionsOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SetOptionsOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AccountID inflationDest;
        private Uint32 clearFlags;
        private Uint32 setFlags;
        private Uint32 masterWeight;
        private Uint32 lowThreshold;
        private Uint32 medThreshold;
        private Uint32 highThreshold;
        private String32 homeDomain;
        private Signer signer;

        public Builder inflationDest(AccountID inflationDest) {
            this.inflationDest = inflationDest;
            return this;
        }

        public Builder clearFlags(Uint32 clearFlags) {
            this.clearFlags = clearFlags;
            return this;
        }

        public Builder setFlags(Uint32 setFlags) {
            this.setFlags = setFlags;
            return this;
        }

        public Builder masterWeight(Uint32 masterWeight) {
            this.masterWeight = masterWeight;
            return this;
        }

        public Builder lowThreshold(Uint32 lowThreshold) {
            this.lowThreshold = lowThreshold;
            return this;
        }

        public Builder medThreshold(Uint32 medThreshold) {
            this.medThreshold = medThreshold;
            return this;
        }

        public Builder highThreshold(Uint32 highThreshold) {
            this.highThreshold = highThreshold;
            return this;
        }

        public Builder homeDomain(String32 homeDomain) {
            this.homeDomain = homeDomain;
            return this;
        }

        public Builder signer(Signer signer) {
            this.signer = signer;
            return this;
        }

        public SetOptionsOp build() {
            SetOptionsOp val = new SetOptionsOp();
            val.setInflationDest(this.inflationDest);
            val.setClearFlags(this.clearFlags);
            val.setSetFlags(this.setFlags);
            val.setMasterWeight(this.masterWeight);
            val.setLowThreshold(this.lowThreshold);
            val.setMedThreshold(this.medThreshold);
            val.setHighThreshold(this.highThreshold);
            val.setHomeDomain(this.homeDomain);
            val.setSigner(this.signer);
            return val;
        }
    }
}

