/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanAddressCredentials
implements XdrElement {
    private SCAddress address;
    private Int64 nonce;
    private Uint32 signatureExpirationLedger;
    private SCVal signature;

    public SCAddress getAddress() {
        return this.address;
    }

    public void setAddress(SCAddress value) {
        this.address = value;
    }

    public Int64 getNonce() {
        return this.nonce;
    }

    public void setNonce(Int64 value) {
        this.nonce = value;
    }

    public Uint32 getSignatureExpirationLedger() {
        return this.signatureExpirationLedger;
    }

    public void setSignatureExpirationLedger(Uint32 value) {
        this.signatureExpirationLedger = value;
    }

    public SCVal getSignature() {
        return this.signature;
    }

    public void setSignature(SCVal value) {
        this.signature = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanAddressCredentials encodedSorobanAddressCredentials) throws IOException {
        SCAddress.encode(stream, encodedSorobanAddressCredentials.address);
        Int64.encode(stream, encodedSorobanAddressCredentials.nonce);
        Uint32.encode(stream, encodedSorobanAddressCredentials.signatureExpirationLedger);
        SCVal.encode(stream, encodedSorobanAddressCredentials.signature);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanAddressCredentials.encode(stream, this);
    }

    public static SorobanAddressCredentials decode(XdrDataInputStream stream) throws IOException {
        SorobanAddressCredentials decodedSorobanAddressCredentials = new SorobanAddressCredentials();
        decodedSorobanAddressCredentials.address = SCAddress.decode(stream);
        decodedSorobanAddressCredentials.nonce = Int64.decode(stream);
        decodedSorobanAddressCredentials.signatureExpirationLedger = Uint32.decode(stream);
        decodedSorobanAddressCredentials.signature = SCVal.decode(stream);
        return decodedSorobanAddressCredentials;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.nonce, this.signatureExpirationLedger, this.signature);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanAddressCredentials)) {
            return false;
        }
        SorobanAddressCredentials other = (SorobanAddressCredentials)object;
        return Objects.equals(this.address, other.address) && Objects.equals(this.nonce, other.nonce) && Objects.equals(this.signatureExpirationLedger, other.signatureExpirationLedger) && Objects.equals(this.signature, other.signature);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanAddressCredentials fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanAddressCredentials.fromXdrByteArray(bytes);
    }

    public static SorobanAddressCredentials fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanAddressCredentials.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCAddress address;
        private Int64 nonce;
        private Uint32 signatureExpirationLedger;
        private SCVal signature;

        public Builder address(SCAddress address) {
            this.address = address;
            return this;
        }

        public Builder nonce(Int64 nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder signatureExpirationLedger(Uint32 signatureExpirationLedger) {
            this.signatureExpirationLedger = signatureExpirationLedger;
            return this;
        }

        public Builder signature(SCVal signature) {
            this.signature = signature;
            return this;
        }

        public SorobanAddressCredentials build() {
            SorobanAddressCredentials val = new SorobanAddressCredentials();
            val.setAddress(this.address);
            val.setNonce(this.nonce);
            val.setSignatureExpirationLedger(this.signatureExpirationLedger);
            val.setSignature(this.signature);
            return val;
        }
    }
}

