/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerFootprint;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanResources
implements XdrElement {
    private LedgerFootprint footprint;
    private Uint32 instructions;
    private Uint32 readBytes;
    private Uint32 writeBytes;

    public LedgerFootprint getFootprint() {
        return this.footprint;
    }

    public void setFootprint(LedgerFootprint value) {
        this.footprint = value;
    }

    public Uint32 getInstructions() {
        return this.instructions;
    }

    public void setInstructions(Uint32 value) {
        this.instructions = value;
    }

    public Uint32 getReadBytes() {
        return this.readBytes;
    }

    public void setReadBytes(Uint32 value) {
        this.readBytes = value;
    }

    public Uint32 getWriteBytes() {
        return this.writeBytes;
    }

    public void setWriteBytes(Uint32 value) {
        this.writeBytes = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanResources encodedSorobanResources) throws IOException {
        LedgerFootprint.encode(stream, encodedSorobanResources.footprint);
        Uint32.encode(stream, encodedSorobanResources.instructions);
        Uint32.encode(stream, encodedSorobanResources.readBytes);
        Uint32.encode(stream, encodedSorobanResources.writeBytes);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanResources.encode(stream, this);
    }

    public static SorobanResources decode(XdrDataInputStream stream) throws IOException {
        SorobanResources decodedSorobanResources = new SorobanResources();
        decodedSorobanResources.footprint = LedgerFootprint.decode(stream);
        decodedSorobanResources.instructions = Uint32.decode(stream);
        decodedSorobanResources.readBytes = Uint32.decode(stream);
        decodedSorobanResources.writeBytes = Uint32.decode(stream);
        return decodedSorobanResources;
    }

    public int hashCode() {
        return Objects.hash(this.footprint, this.instructions, this.readBytes, this.writeBytes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanResources)) {
            return false;
        }
        SorobanResources other = (SorobanResources)object;
        return Objects.equals(this.footprint, other.footprint) && Objects.equals(this.instructions, other.instructions) && Objects.equals(this.readBytes, other.readBytes) && Objects.equals(this.writeBytes, other.writeBytes);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanResources fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanResources.fromXdrByteArray(bytes);
    }

    public static SorobanResources fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanResources.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LedgerFootprint footprint;
        private Uint32 instructions;
        private Uint32 readBytes;
        private Uint32 writeBytes;

        public Builder footprint(LedgerFootprint footprint) {
            this.footprint = footprint;
            return this;
        }

        public Builder instructions(Uint32 instructions) {
            this.instructions = instructions;
            return this;
        }

        public Builder readBytes(Uint32 readBytes) {
            this.readBytes = readBytes;
            return this;
        }

        public Builder writeBytes(Uint32 writeBytes) {
            this.writeBytes = writeBytes;
            return this;
        }

        public SorobanResources build() {
            SorobanResources val = new SorobanResources();
            val.setFootprint(this.footprint);
            val.setInstructions(this.instructions);
            val.setReadBytes(this.readBytes);
            val.setWriteBytes(this.writeBytes);
            return val;
        }
    }
}

