/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LedgerCloseValueSignature;
import org.stellar.sdk.xdr.StellarValueType;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.UpgradeType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class StellarValue
implements XdrElement {
    private Hash txSetHash;
    private TimePoint closeTime;
    private UpgradeType[] upgrades;
    private StellarValueExt ext;

    public Hash getTxSetHash() {
        return this.txSetHash;
    }

    public void setTxSetHash(Hash value) {
        this.txSetHash = value;
    }

    public TimePoint getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(TimePoint value) {
        this.closeTime = value;
    }

    public UpgradeType[] getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(UpgradeType[] value) {
        this.upgrades = value;
    }

    public StellarValueExt getExt() {
        return this.ext;
    }

    public void setExt(StellarValueExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, StellarValue encodedStellarValue) throws IOException {
        Hash.encode(stream, encodedStellarValue.txSetHash);
        TimePoint.encode(stream, encodedStellarValue.closeTime);
        int upgradessize = encodedStellarValue.getUpgrades().length;
        stream.writeInt(upgradessize);
        for (int i = 0; i < upgradessize; ++i) {
            UpgradeType.encode(stream, encodedStellarValue.upgrades[i]);
        }
        StellarValueExt.encode(stream, encodedStellarValue.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        StellarValue.encode(stream, this);
    }

    public static StellarValue decode(XdrDataInputStream stream) throws IOException {
        StellarValue decodedStellarValue = new StellarValue();
        decodedStellarValue.txSetHash = Hash.decode(stream);
        decodedStellarValue.closeTime = TimePoint.decode(stream);
        int upgradessize = stream.readInt();
        decodedStellarValue.upgrades = new UpgradeType[upgradessize];
        for (int i = 0; i < upgradessize; ++i) {
            decodedStellarValue.upgrades[i] = UpgradeType.decode(stream);
        }
        decodedStellarValue.ext = StellarValueExt.decode(stream);
        return decodedStellarValue;
    }

    public int hashCode() {
        return Objects.hash(this.txSetHash, this.closeTime, Arrays.hashCode(this.upgrades), this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof StellarValue)) {
            return false;
        }
        StellarValue other = (StellarValue)object;
        return Objects.equals(this.txSetHash, other.txSetHash) && Objects.equals(this.closeTime, other.closeTime) && Arrays.equals(this.upgrades, other.upgrades) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static StellarValue fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return StellarValue.fromXdrByteArray(bytes);
    }

    public static StellarValue fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return StellarValue.decode(xdrDataInputStream);
    }

    public static class StellarValueExt
    implements XdrElement {
        StellarValueType v;
        private LedgerCloseValueSignature lcValueSignature;

        public StellarValueType getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(StellarValueType value) {
            this.v = value;
        }

        public LedgerCloseValueSignature getLcValueSignature() {
            return this.lcValueSignature;
        }

        public void setLcValueSignature(LedgerCloseValueSignature value) {
            this.lcValueSignature = value;
        }

        public static void encode(XdrDataOutputStream stream, StellarValueExt encodedStellarValueExt) throws IOException {
            stream.writeInt(encodedStellarValueExt.getDiscriminant().getValue());
            switch (encodedStellarValueExt.getDiscriminant()) {
                case STELLAR_VALUE_BASIC: {
                    break;
                }
                case STELLAR_VALUE_SIGNED: {
                    LedgerCloseValueSignature.encode(stream, encodedStellarValueExt.lcValueSignature);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            StellarValueExt.encode(stream, this);
        }

        public static StellarValueExt decode(XdrDataInputStream stream) throws IOException {
            StellarValueExt decodedStellarValueExt = new StellarValueExt();
            StellarValueType discriminant = StellarValueType.decode(stream);
            decodedStellarValueExt.setDiscriminant(discriminant);
            switch (decodedStellarValueExt.getDiscriminant()) {
                case STELLAR_VALUE_BASIC: {
                    break;
                }
                case STELLAR_VALUE_SIGNED: {
                    decodedStellarValueExt.lcValueSignature = LedgerCloseValueSignature.decode(stream);
                }
            }
            return decodedStellarValueExt;
        }

        public int hashCode() {
            return Objects.hash(this.lcValueSignature, this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof StellarValueExt)) {
                return false;
            }
            StellarValueExt other = (StellarValueExt)object;
            return Objects.equals(this.lcValueSignature, other.lcValueSignature) && Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static StellarValueExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return StellarValueExt.fromXdrByteArray(bytes);
        }

        public static StellarValueExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return StellarValueExt.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private StellarValueType discriminant;
            private LedgerCloseValueSignature lcValueSignature;

            public Builder discriminant(StellarValueType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder lcValueSignature(LedgerCloseValueSignature lcValueSignature) {
                this.lcValueSignature = lcValueSignature;
                return this;
            }

            public StellarValueExt build() {
                StellarValueExt val = new StellarValueExt();
                val.setDiscriminant(this.discriminant);
                val.setLcValueSignature(this.lcValueSignature);
                return val;
            }
        }
    }

    public static final class Builder {
        private Hash txSetHash;
        private TimePoint closeTime;
        private UpgradeType[] upgrades;
        private StellarValueExt ext;

        public Builder txSetHash(Hash txSetHash) {
            this.txSetHash = txSetHash;
            return this;
        }

        public Builder closeTime(TimePoint closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        public Builder upgrades(UpgradeType[] upgrades) {
            this.upgrades = upgrades;
            return this;
        }

        public Builder ext(StellarValueExt ext) {
            this.ext = ext;
            return this;
        }

        public StellarValue build() {
            StellarValue val = new StellarValue();
            val.setTxSetHash(this.txSetHash);
            val.setCloseTime(this.closeTime);
            val.setUpgrades(this.upgrades);
            val.setExt(this.ext);
            return val;
        }
    }
}

