// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct BucketMetadata
//  {
//      // Indicates the protocol version used to create / merge this bucket.
//      uint32 ledgerVersion;
//
//      // reserved for future use
//      union switch (int v)
//      {
//      case 0:
//          void;
//      }
//      ext;
//  };

//  ===========================================================================
public class BucketMetadata implements XdrElement {
  public BucketMetadata() {}

  private Uint32 ledgerVersion;

  public Uint32 getLedgerVersion() {
    return this.ledgerVersion;
  }

  public void setLedgerVersion(Uint32 value) {
    this.ledgerVersion = value;
  }

  private BucketMetadataExt ext;

  public BucketMetadataExt getExt() {
    return this.ext;
  }

  public void setExt(BucketMetadataExt value) {
    this.ext = value;
  }

  public static void encode(XdrDataOutputStream stream, BucketMetadata encodedBucketMetadata)
      throws IOException {
    Uint32.encode(stream, encodedBucketMetadata.ledgerVersion);
    BucketMetadataExt.encode(stream, encodedBucketMetadata.ext);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static BucketMetadata decode(XdrDataInputStream stream) throws IOException {
    BucketMetadata decodedBucketMetadata = new BucketMetadata();
    decodedBucketMetadata.ledgerVersion = Uint32.decode(stream);
    decodedBucketMetadata.ext = BucketMetadataExt.decode(stream);
    return decodedBucketMetadata;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.ledgerVersion, this.ext);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof BucketMetadata)) {
      return false;
    }

    BucketMetadata other = (BucketMetadata) object;
    return Objects.equals(this.ledgerVersion, other.ledgerVersion)
        && Objects.equals(this.ext, other.ext);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static BucketMetadata fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static BucketMetadata fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Uint32 ledgerVersion;
    private BucketMetadataExt ext;

    public Builder ledgerVersion(Uint32 ledgerVersion) {
      this.ledgerVersion = ledgerVersion;
      return this;
    }

    public Builder ext(BucketMetadataExt ext) {
      this.ext = ext;
      return this;
    }

    public BucketMetadata build() {
      BucketMetadata val = new BucketMetadata();
      val.setLedgerVersion(this.ledgerVersion);
      val.setExt(this.ext);
      return val;
    }
  }

  public static class BucketMetadataExt implements XdrElement {
    public BucketMetadataExt() {}

    Integer v;

    public Integer getDiscriminant() {
      return this.v;
    }

    public void setDiscriminant(Integer value) {
      this.v = value;
    }

    public static final class Builder {
      private Integer discriminant;

      public Builder discriminant(Integer discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public BucketMetadataExt build() {
        BucketMetadataExt val = new BucketMetadataExt();
        val.setDiscriminant(discriminant);
        return val;
      }
    }

    public static void encode(
        XdrDataOutputStream stream, BucketMetadataExt encodedBucketMetadataExt) throws IOException {
      // Xdrgen::AST::Typespecs::Int
      // Integer
      stream.writeInt(encodedBucketMetadataExt.getDiscriminant().intValue());
      switch (encodedBucketMetadataExt.getDiscriminant()) {
        case 0:
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static BucketMetadataExt decode(XdrDataInputStream stream) throws IOException {
      BucketMetadataExt decodedBucketMetadataExt = new BucketMetadataExt();
      Integer discriminant = stream.readInt();
      decodedBucketMetadataExt.setDiscriminant(discriminant);
      switch (decodedBucketMetadataExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedBucketMetadataExt;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.v);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof BucketMetadataExt)) {
        return false;
      }

      BucketMetadataExt other = (BucketMetadataExt) object;
      return Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static BucketMetadataExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static BucketMetadataExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
