// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct Curve25519Secret
//  {
//      opaque key[32];
//  };

//  ===========================================================================
public class Curve25519Secret implements XdrElement {
  public Curve25519Secret() {}

  private byte[] key;

  public byte[] getKey() {
    return this.key;
  }

  public void setKey(byte[] value) {
    this.key = value;
  }

  public static void encode(XdrDataOutputStream stream, Curve25519Secret encodedCurve25519Secret)
      throws IOException {
    int keysize = encodedCurve25519Secret.key.length;
    stream.write(encodedCurve25519Secret.getKey(), 0, keysize);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static Curve25519Secret decode(XdrDataInputStream stream) throws IOException {
    Curve25519Secret decodedCurve25519Secret = new Curve25519Secret();
    int keysize = 32;
    decodedCurve25519Secret.key = new byte[keysize];
    stream.read(decodedCurve25519Secret.key, 0, keysize);
    return decodedCurve25519Secret;
  }

  @Override
  public int hashCode() {
    return Arrays.hashCode(this.key);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof Curve25519Secret)) {
      return false;
    }

    Curve25519Secret other = (Curve25519Secret) object;
    return Arrays.equals(this.key, other.key);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static Curve25519Secret fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Curve25519Secret fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private byte[] key;

    public Builder key(byte[] key) {
      this.key = key;
      return this;
    }

    public Curve25519Secret build() {
      Curve25519Secret val = new Curve25519Secret();
      val.setKey(this.key);
      return val;
    }
  }
}
