// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct InnerTransactionResult
//  {
//      // Always 0. Here for binary compatibility.
//      int64 feeCharged;
//
//      union switch (TransactionResultCode code)
//      {
//      // txFEE_BUMP_INNER_SUCCESS is not included
//      case txSUCCESS:
//      case txFAILED:
//          OperationResult results<>;
//      case txTOO_EARLY:
//      case txTOO_LATE:
//      case txMISSING_OPERATION:
//      case txBAD_SEQ:
//      case txBAD_AUTH:
//      case txINSUFFICIENT_BALANCE:
//      case txNO_ACCOUNT:
//      case txINSUFFICIENT_FEE:
//      case txBAD_AUTH_EXTRA:
//      case txINTERNAL_ERROR:
//      case txNOT_SUPPORTED:
//      // txFEE_BUMP_INNER_FAILED is not included
//      case txBAD_SPONSORSHIP:
//      case txBAD_MIN_SEQ_AGE_OR_GAP:
//      case txMALFORMED:
//      case txSOROBAN_INVALID:
//          void;
//      }
//      result;
//
//      // reserved for future use
//      union switch (int v)
//      {
//      case 0:
//          void;
//      }
//      ext;
//  };

//  ===========================================================================
public class InnerTransactionResult implements XdrElement {
  public InnerTransactionResult() {}

  private Int64 feeCharged;

  public Int64 getFeeCharged() {
    return this.feeCharged;
  }

  public void setFeeCharged(Int64 value) {
    this.feeCharged = value;
  }

  private InnerTransactionResultResult result;

  public InnerTransactionResultResult getResult() {
    return this.result;
  }

  public void setResult(InnerTransactionResultResult value) {
    this.result = value;
  }

  private InnerTransactionResultExt ext;

  public InnerTransactionResultExt getExt() {
    return this.ext;
  }

  public void setExt(InnerTransactionResultExt value) {
    this.ext = value;
  }

  public static void encode(
      XdrDataOutputStream stream, InnerTransactionResult encodedInnerTransactionResult)
      throws IOException {
    Int64.encode(stream, encodedInnerTransactionResult.feeCharged);
    InnerTransactionResultResult.encode(stream, encodedInnerTransactionResult.result);
    InnerTransactionResultExt.encode(stream, encodedInnerTransactionResult.ext);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static InnerTransactionResult decode(XdrDataInputStream stream) throws IOException {
    InnerTransactionResult decodedInnerTransactionResult = new InnerTransactionResult();
    decodedInnerTransactionResult.feeCharged = Int64.decode(stream);
    decodedInnerTransactionResult.result = InnerTransactionResultResult.decode(stream);
    decodedInnerTransactionResult.ext = InnerTransactionResultExt.decode(stream);
    return decodedInnerTransactionResult;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.feeCharged, this.result, this.ext);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof InnerTransactionResult)) {
      return false;
    }

    InnerTransactionResult other = (InnerTransactionResult) object;
    return Objects.equals(this.feeCharged, other.feeCharged)
        && Objects.equals(this.result, other.result)
        && Objects.equals(this.ext, other.ext);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static InnerTransactionResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static InnerTransactionResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Int64 feeCharged;
    private InnerTransactionResultResult result;
    private InnerTransactionResultExt ext;

    public Builder feeCharged(Int64 feeCharged) {
      this.feeCharged = feeCharged;
      return this;
    }

    public Builder result(InnerTransactionResultResult result) {
      this.result = result;
      return this;
    }

    public Builder ext(InnerTransactionResultExt ext) {
      this.ext = ext;
      return this;
    }

    public InnerTransactionResult build() {
      InnerTransactionResult val = new InnerTransactionResult();
      val.setFeeCharged(this.feeCharged);
      val.setResult(this.result);
      val.setExt(this.ext);
      return val;
    }
  }

  public static class InnerTransactionResultResult implements XdrElement {
    public InnerTransactionResultResult() {}

    TransactionResultCode code;

    public TransactionResultCode getDiscriminant() {
      return this.code;
    }

    public void setDiscriminant(TransactionResultCode value) {
      this.code = value;
    }

    private OperationResult[] results;

    public OperationResult[] getResults() {
      return this.results;
    }

    public void setResults(OperationResult[] value) {
      this.results = value;
    }

    public static final class Builder {
      private TransactionResultCode discriminant;
      private OperationResult[] results;

      public Builder discriminant(TransactionResultCode discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder results(OperationResult[] results) {
        this.results = results;
        return this;
      }

      public InnerTransactionResultResult build() {
        InnerTransactionResultResult val = new InnerTransactionResultResult();
        val.setDiscriminant(discriminant);
        val.setResults(this.results);
        return val;
      }
    }

    public static void encode(
        XdrDataOutputStream stream,
        InnerTransactionResultResult encodedInnerTransactionResultResult)
        throws IOException {
      // Xdrgen::AST::Identifier
      // TransactionResultCode
      stream.writeInt(encodedInnerTransactionResultResult.getDiscriminant().getValue());
      switch (encodedInnerTransactionResultResult.getDiscriminant()) {
        case txSUCCESS:
        case txFAILED:
          int resultssize = encodedInnerTransactionResultResult.getResults().length;
          stream.writeInt(resultssize);
          for (int i = 0; i < resultssize; i++) {
            OperationResult.encode(stream, encodedInnerTransactionResultResult.results[i]);
          }
          break;
        case txTOO_EARLY:
        case txTOO_LATE:
        case txMISSING_OPERATION:
        case txBAD_SEQ:
        case txBAD_AUTH:
        case txINSUFFICIENT_BALANCE:
        case txNO_ACCOUNT:
        case txINSUFFICIENT_FEE:
        case txBAD_AUTH_EXTRA:
        case txINTERNAL_ERROR:
        case txNOT_SUPPORTED:
        case txBAD_SPONSORSHIP:
        case txBAD_MIN_SEQ_AGE_OR_GAP:
        case txMALFORMED:
        case txSOROBAN_INVALID:
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static InnerTransactionResultResult decode(XdrDataInputStream stream)
        throws IOException {
      InnerTransactionResultResult decodedInnerTransactionResultResult =
          new InnerTransactionResultResult();
      TransactionResultCode discriminant = TransactionResultCode.decode(stream);
      decodedInnerTransactionResultResult.setDiscriminant(discriminant);
      switch (decodedInnerTransactionResultResult.getDiscriminant()) {
        case txSUCCESS:
        case txFAILED:
          int resultssize = stream.readInt();
          decodedInnerTransactionResultResult.results = new OperationResult[resultssize];
          for (int i = 0; i < resultssize; i++) {
            decodedInnerTransactionResultResult.results[i] = OperationResult.decode(stream);
          }
          break;
        case txTOO_EARLY:
        case txTOO_LATE:
        case txMISSING_OPERATION:
        case txBAD_SEQ:
        case txBAD_AUTH:
        case txINSUFFICIENT_BALANCE:
        case txNO_ACCOUNT:
        case txINSUFFICIENT_FEE:
        case txBAD_AUTH_EXTRA:
        case txINTERNAL_ERROR:
        case txNOT_SUPPORTED:
        case txBAD_SPONSORSHIP:
        case txBAD_MIN_SEQ_AGE_OR_GAP:
        case txMALFORMED:
        case txSOROBAN_INVALID:
          break;
      }
      return decodedInnerTransactionResultResult;
    }

    @Override
    public int hashCode() {
      return Objects.hash(Arrays.hashCode(this.results), this.code);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof InnerTransactionResultResult)) {
        return false;
      }

      InnerTransactionResultResult other = (InnerTransactionResultResult) object;
      return Arrays.equals(this.results, other.results) && Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static InnerTransactionResultResult fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static InnerTransactionResultResult fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  public static class InnerTransactionResultExt implements XdrElement {
    public InnerTransactionResultExt() {}

    Integer v;

    public Integer getDiscriminant() {
      return this.v;
    }

    public void setDiscriminant(Integer value) {
      this.v = value;
    }

    public static final class Builder {
      private Integer discriminant;

      public Builder discriminant(Integer discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public InnerTransactionResultExt build() {
        InnerTransactionResultExt val = new InnerTransactionResultExt();
        val.setDiscriminant(discriminant);
        return val;
      }
    }

    public static void encode(
        XdrDataOutputStream stream, InnerTransactionResultExt encodedInnerTransactionResultExt)
        throws IOException {
      // Xdrgen::AST::Typespecs::Int
      // Integer
      stream.writeInt(encodedInnerTransactionResultExt.getDiscriminant().intValue());
      switch (encodedInnerTransactionResultExt.getDiscriminant()) {
        case 0:
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static InnerTransactionResultExt decode(XdrDataInputStream stream) throws IOException {
      InnerTransactionResultExt decodedInnerTransactionResultExt = new InnerTransactionResultExt();
      Integer discriminant = stream.readInt();
      decodedInnerTransactionResultExt.setDiscriminant(discriminant);
      switch (decodedInnerTransactionResultExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedInnerTransactionResultExt;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.v);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof InnerTransactionResultExt)) {
        return false;
      }

      InnerTransactionResultExt other = (InnerTransactionResultExt) object;
      return Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static InnerTransactionResultExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static InnerTransactionResultExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
