// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct LedgerHeader
//  {
//      uint32 ledgerVersion;    // the protocol version of the ledger
//      Hash previousLedgerHash; // hash of the previous ledger header
//      StellarValue scpValue;   // what consensus agreed to
//      Hash txSetResultHash;    // the TransactionResultSet that led to this ledger
//      Hash bucketListHash;     // hash of the ledger state
//
//      uint32 ledgerSeq; // sequence number of this ledger
//
//      int64 totalCoins; // total number of stroops in existence.
//                        // 10,000,000 stroops in 1 XLM
//
//      int64 feePool;       // fees burned since last inflation run
//      uint32 inflationSeq; // inflation sequence number
//
//      uint64 idPool; // last used global ID, used for generating objects
//
//      uint32 baseFee;     // base fee per operation in stroops
//      uint32 baseReserve; // account base reserve in stroops
//
//      uint32 maxTxSetSize; // maximum size a transaction set can be
//
//      Hash skipList[4]; // hashes of ledgers in the past. allows you to jump back
//                        // in time without walking the chain back ledger by ledger
//                        // each slot contains the oldest ledger that is mod of
//                        // either 50  5000  50000 or 500000 depending on index
//                        // skipList[0] mod(50), skipList[1] mod(5000), etc
//
//      // reserved for future use
//      union switch (int v)
//      {
//      case 0:
//          void;
//      case 1:
//          LedgerHeaderExtensionV1 v1;
//      }
//      ext;
//  };

//  ===========================================================================
public class LedgerHeader implements XdrElement {
  public LedgerHeader() {}

  private Uint32 ledgerVersion;

  public Uint32 getLedgerVersion() {
    return this.ledgerVersion;
  }

  public void setLedgerVersion(Uint32 value) {
    this.ledgerVersion = value;
  }

  private Hash previousLedgerHash;

  public Hash getPreviousLedgerHash() {
    return this.previousLedgerHash;
  }

  public void setPreviousLedgerHash(Hash value) {
    this.previousLedgerHash = value;
  }

  private StellarValue scpValue;

  public StellarValue getScpValue() {
    return this.scpValue;
  }

  public void setScpValue(StellarValue value) {
    this.scpValue = value;
  }

  private Hash txSetResultHash;

  public Hash getTxSetResultHash() {
    return this.txSetResultHash;
  }

  public void setTxSetResultHash(Hash value) {
    this.txSetResultHash = value;
  }

  private Hash bucketListHash;

  public Hash getBucketListHash() {
    return this.bucketListHash;
  }

  public void setBucketListHash(Hash value) {
    this.bucketListHash = value;
  }

  private Uint32 ledgerSeq;

  public Uint32 getLedgerSeq() {
    return this.ledgerSeq;
  }

  public void setLedgerSeq(Uint32 value) {
    this.ledgerSeq = value;
  }

  private Int64 totalCoins;

  public Int64 getTotalCoins() {
    return this.totalCoins;
  }

  public void setTotalCoins(Int64 value) {
    this.totalCoins = value;
  }

  private Int64 feePool;

  public Int64 getFeePool() {
    return this.feePool;
  }

  public void setFeePool(Int64 value) {
    this.feePool = value;
  }

  private Uint32 inflationSeq;

  public Uint32 getInflationSeq() {
    return this.inflationSeq;
  }

  public void setInflationSeq(Uint32 value) {
    this.inflationSeq = value;
  }

  private Uint64 idPool;

  public Uint64 getIdPool() {
    return this.idPool;
  }

  public void setIdPool(Uint64 value) {
    this.idPool = value;
  }

  private Uint32 baseFee;

  public Uint32 getBaseFee() {
    return this.baseFee;
  }

  public void setBaseFee(Uint32 value) {
    this.baseFee = value;
  }

  private Uint32 baseReserve;

  public Uint32 getBaseReserve() {
    return this.baseReserve;
  }

  public void setBaseReserve(Uint32 value) {
    this.baseReserve = value;
  }

  private Uint32 maxTxSetSize;

  public Uint32 getMaxTxSetSize() {
    return this.maxTxSetSize;
  }

  public void setMaxTxSetSize(Uint32 value) {
    this.maxTxSetSize = value;
  }

  private Hash[] skipList;

  public Hash[] getSkipList() {
    return this.skipList;
  }

  public void setSkipList(Hash[] value) {
    this.skipList = value;
  }

  private LedgerHeaderExt ext;

  public LedgerHeaderExt getExt() {
    return this.ext;
  }

  public void setExt(LedgerHeaderExt value) {
    this.ext = value;
  }

  public static void encode(XdrDataOutputStream stream, LedgerHeader encodedLedgerHeader)
      throws IOException {
    Uint32.encode(stream, encodedLedgerHeader.ledgerVersion);
    Hash.encode(stream, encodedLedgerHeader.previousLedgerHash);
    StellarValue.encode(stream, encodedLedgerHeader.scpValue);
    Hash.encode(stream, encodedLedgerHeader.txSetResultHash);
    Hash.encode(stream, encodedLedgerHeader.bucketListHash);
    Uint32.encode(stream, encodedLedgerHeader.ledgerSeq);
    Int64.encode(stream, encodedLedgerHeader.totalCoins);
    Int64.encode(stream, encodedLedgerHeader.feePool);
    Uint32.encode(stream, encodedLedgerHeader.inflationSeq);
    Uint64.encode(stream, encodedLedgerHeader.idPool);
    Uint32.encode(stream, encodedLedgerHeader.baseFee);
    Uint32.encode(stream, encodedLedgerHeader.baseReserve);
    Uint32.encode(stream, encodedLedgerHeader.maxTxSetSize);
    int skipListsize = encodedLedgerHeader.getSkipList().length;
    for (int i = 0; i < skipListsize; i++) {
      Hash.encode(stream, encodedLedgerHeader.skipList[i]);
    }
    LedgerHeaderExt.encode(stream, encodedLedgerHeader.ext);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static LedgerHeader decode(XdrDataInputStream stream) throws IOException {
    LedgerHeader decodedLedgerHeader = new LedgerHeader();
    decodedLedgerHeader.ledgerVersion = Uint32.decode(stream);
    decodedLedgerHeader.previousLedgerHash = Hash.decode(stream);
    decodedLedgerHeader.scpValue = StellarValue.decode(stream);
    decodedLedgerHeader.txSetResultHash = Hash.decode(stream);
    decodedLedgerHeader.bucketListHash = Hash.decode(stream);
    decodedLedgerHeader.ledgerSeq = Uint32.decode(stream);
    decodedLedgerHeader.totalCoins = Int64.decode(stream);
    decodedLedgerHeader.feePool = Int64.decode(stream);
    decodedLedgerHeader.inflationSeq = Uint32.decode(stream);
    decodedLedgerHeader.idPool = Uint64.decode(stream);
    decodedLedgerHeader.baseFee = Uint32.decode(stream);
    decodedLedgerHeader.baseReserve = Uint32.decode(stream);
    decodedLedgerHeader.maxTxSetSize = Uint32.decode(stream);
    int skipListsize = 4;
    decodedLedgerHeader.skipList = new Hash[skipListsize];
    for (int i = 0; i < skipListsize; i++) {
      decodedLedgerHeader.skipList[i] = Hash.decode(stream);
    }
    decodedLedgerHeader.ext = LedgerHeaderExt.decode(stream);
    return decodedLedgerHeader;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        this.ledgerVersion,
        this.previousLedgerHash,
        this.scpValue,
        this.txSetResultHash,
        this.bucketListHash,
        this.ledgerSeq,
        this.totalCoins,
        this.feePool,
        this.inflationSeq,
        this.idPool,
        this.baseFee,
        this.baseReserve,
        this.maxTxSetSize,
        Arrays.hashCode(this.skipList),
        this.ext);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof LedgerHeader)) {
      return false;
    }

    LedgerHeader other = (LedgerHeader) object;
    return Objects.equals(this.ledgerVersion, other.ledgerVersion)
        && Objects.equals(this.previousLedgerHash, other.previousLedgerHash)
        && Objects.equals(this.scpValue, other.scpValue)
        && Objects.equals(this.txSetResultHash, other.txSetResultHash)
        && Objects.equals(this.bucketListHash, other.bucketListHash)
        && Objects.equals(this.ledgerSeq, other.ledgerSeq)
        && Objects.equals(this.totalCoins, other.totalCoins)
        && Objects.equals(this.feePool, other.feePool)
        && Objects.equals(this.inflationSeq, other.inflationSeq)
        && Objects.equals(this.idPool, other.idPool)
        && Objects.equals(this.baseFee, other.baseFee)
        && Objects.equals(this.baseReserve, other.baseReserve)
        && Objects.equals(this.maxTxSetSize, other.maxTxSetSize)
        && Arrays.equals(this.skipList, other.skipList)
        && Objects.equals(this.ext, other.ext);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static LedgerHeader fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerHeader fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Uint32 ledgerVersion;
    private Hash previousLedgerHash;
    private StellarValue scpValue;
    private Hash txSetResultHash;
    private Hash bucketListHash;
    private Uint32 ledgerSeq;
    private Int64 totalCoins;
    private Int64 feePool;
    private Uint32 inflationSeq;
    private Uint64 idPool;
    private Uint32 baseFee;
    private Uint32 baseReserve;
    private Uint32 maxTxSetSize;
    private Hash[] skipList;
    private LedgerHeaderExt ext;

    public Builder ledgerVersion(Uint32 ledgerVersion) {
      this.ledgerVersion = ledgerVersion;
      return this;
    }

    public Builder previousLedgerHash(Hash previousLedgerHash) {
      this.previousLedgerHash = previousLedgerHash;
      return this;
    }

    public Builder scpValue(StellarValue scpValue) {
      this.scpValue = scpValue;
      return this;
    }

    public Builder txSetResultHash(Hash txSetResultHash) {
      this.txSetResultHash = txSetResultHash;
      return this;
    }

    public Builder bucketListHash(Hash bucketListHash) {
      this.bucketListHash = bucketListHash;
      return this;
    }

    public Builder ledgerSeq(Uint32 ledgerSeq) {
      this.ledgerSeq = ledgerSeq;
      return this;
    }

    public Builder totalCoins(Int64 totalCoins) {
      this.totalCoins = totalCoins;
      return this;
    }

    public Builder feePool(Int64 feePool) {
      this.feePool = feePool;
      return this;
    }

    public Builder inflationSeq(Uint32 inflationSeq) {
      this.inflationSeq = inflationSeq;
      return this;
    }

    public Builder idPool(Uint64 idPool) {
      this.idPool = idPool;
      return this;
    }

    public Builder baseFee(Uint32 baseFee) {
      this.baseFee = baseFee;
      return this;
    }

    public Builder baseReserve(Uint32 baseReserve) {
      this.baseReserve = baseReserve;
      return this;
    }

    public Builder maxTxSetSize(Uint32 maxTxSetSize) {
      this.maxTxSetSize = maxTxSetSize;
      return this;
    }

    public Builder skipList(Hash[] skipList) {
      this.skipList = skipList;
      return this;
    }

    public Builder ext(LedgerHeaderExt ext) {
      this.ext = ext;
      return this;
    }

    public LedgerHeader build() {
      LedgerHeader val = new LedgerHeader();
      val.setLedgerVersion(this.ledgerVersion);
      val.setPreviousLedgerHash(this.previousLedgerHash);
      val.setScpValue(this.scpValue);
      val.setTxSetResultHash(this.txSetResultHash);
      val.setBucketListHash(this.bucketListHash);
      val.setLedgerSeq(this.ledgerSeq);
      val.setTotalCoins(this.totalCoins);
      val.setFeePool(this.feePool);
      val.setInflationSeq(this.inflationSeq);
      val.setIdPool(this.idPool);
      val.setBaseFee(this.baseFee);
      val.setBaseReserve(this.baseReserve);
      val.setMaxTxSetSize(this.maxTxSetSize);
      val.setSkipList(this.skipList);
      val.setExt(this.ext);
      return val;
    }
  }

  public static class LedgerHeaderExt implements XdrElement {
    public LedgerHeaderExt() {}

    Integer v;

    public Integer getDiscriminant() {
      return this.v;
    }

    public void setDiscriminant(Integer value) {
      this.v = value;
    }

    private LedgerHeaderExtensionV1 v1;

    public LedgerHeaderExtensionV1 getV1() {
      return this.v1;
    }

    public void setV1(LedgerHeaderExtensionV1 value) {
      this.v1 = value;
    }

    public static final class Builder {
      private Integer discriminant;
      private LedgerHeaderExtensionV1 v1;

      public Builder discriminant(Integer discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder v1(LedgerHeaderExtensionV1 v1) {
        this.v1 = v1;
        return this;
      }

      public LedgerHeaderExt build() {
        LedgerHeaderExt val = new LedgerHeaderExt();
        val.setDiscriminant(discriminant);
        val.setV1(this.v1);
        return val;
      }
    }

    public static void encode(XdrDataOutputStream stream, LedgerHeaderExt encodedLedgerHeaderExt)
        throws IOException {
      // Xdrgen::AST::Typespecs::Int
      // Integer
      stream.writeInt(encodedLedgerHeaderExt.getDiscriminant().intValue());
      switch (encodedLedgerHeaderExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          LedgerHeaderExtensionV1.encode(stream, encodedLedgerHeaderExt.v1);
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerHeaderExt decode(XdrDataInputStream stream) throws IOException {
      LedgerHeaderExt decodedLedgerHeaderExt = new LedgerHeaderExt();
      Integer discriminant = stream.readInt();
      decodedLedgerHeaderExt.setDiscriminant(discriminant);
      switch (decodedLedgerHeaderExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedLedgerHeaderExt.v1 = LedgerHeaderExtensionV1.decode(stream);
          break;
      }
      return decodedLedgerHeaderExt;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.v1, this.v);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerHeaderExt)) {
        return false;
      }

      LedgerHeaderExt other = (LedgerHeaderExt) object;
      return Objects.equals(this.v1, other.v1) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerHeaderExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerHeaderExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
