// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  union LedgerKey switch (LedgerEntryType type)
//  {
//  case ACCOUNT:
//      struct
//      {
//          AccountID accountID;
//      } account;
//
//  case TRUSTLINE:
//      struct
//      {
//          AccountID accountID;
//          TrustLineAsset asset;
//      } trustLine;
//
//  case OFFER:
//      struct
//      {
//          AccountID sellerID;
//          int64 offerID;
//      } offer;
//
//  case DATA:
//      struct
//      {
//          AccountID accountID;
//          string64 dataName;
//      } data;
//
//  case CLAIMABLE_BALANCE:
//      struct
//      {
//          ClaimableBalanceID balanceID;
//      } claimableBalance;
//
//  case LIQUIDITY_POOL:
//      struct
//      {
//          PoolID liquidityPoolID;
//      } liquidityPool;
//  case CONTRACT_DATA:
//      struct
//      {
//          SCAddress contract;
//          SCVal key;
//          ContractDataDurability durability;
//      } contractData;
//  case CONTRACT_CODE:
//      struct
//      {
//          Hash hash;
//      } contractCode;
//  case CONFIG_SETTING:
//      struct
//      {
//          ConfigSettingID configSettingID;
//      } configSetting;
//  case TTL:
//      struct
//      {
//          // Hash of the LedgerKey that is associated with this TTLEntry
//          Hash keyHash;
//      } ttl;
//  };

//  ===========================================================================
public class LedgerKey implements XdrElement {
  public LedgerKey() {}

  LedgerEntryType type;

  public LedgerEntryType getDiscriminant() {
    return this.type;
  }

  public void setDiscriminant(LedgerEntryType value) {
    this.type = value;
  }

  private LedgerKeyAccount account;

  public LedgerKeyAccount getAccount() {
    return this.account;
  }

  public void setAccount(LedgerKeyAccount value) {
    this.account = value;
  }

  private LedgerKeyTrustLine trustLine;

  public LedgerKeyTrustLine getTrustLine() {
    return this.trustLine;
  }

  public void setTrustLine(LedgerKeyTrustLine value) {
    this.trustLine = value;
  }

  private LedgerKeyOffer offer;

  public LedgerKeyOffer getOffer() {
    return this.offer;
  }

  public void setOffer(LedgerKeyOffer value) {
    this.offer = value;
  }

  private LedgerKeyData data;

  public LedgerKeyData getData() {
    return this.data;
  }

  public void setData(LedgerKeyData value) {
    this.data = value;
  }

  private LedgerKeyClaimableBalance claimableBalance;

  public LedgerKeyClaimableBalance getClaimableBalance() {
    return this.claimableBalance;
  }

  public void setClaimableBalance(LedgerKeyClaimableBalance value) {
    this.claimableBalance = value;
  }

  private LedgerKeyLiquidityPool liquidityPool;

  public LedgerKeyLiquidityPool getLiquidityPool() {
    return this.liquidityPool;
  }

  public void setLiquidityPool(LedgerKeyLiquidityPool value) {
    this.liquidityPool = value;
  }

  private LedgerKeyContractData contractData;

  public LedgerKeyContractData getContractData() {
    return this.contractData;
  }

  public void setContractData(LedgerKeyContractData value) {
    this.contractData = value;
  }

  private LedgerKeyContractCode contractCode;

  public LedgerKeyContractCode getContractCode() {
    return this.contractCode;
  }

  public void setContractCode(LedgerKeyContractCode value) {
    this.contractCode = value;
  }

  private LedgerKeyConfigSetting configSetting;

  public LedgerKeyConfigSetting getConfigSetting() {
    return this.configSetting;
  }

  public void setConfigSetting(LedgerKeyConfigSetting value) {
    this.configSetting = value;
  }

  private LedgerKeyTtl ttl;

  public LedgerKeyTtl getTtl() {
    return this.ttl;
  }

  public void setTtl(LedgerKeyTtl value) {
    this.ttl = value;
  }

  public static final class Builder {
    private LedgerEntryType discriminant;
    private LedgerKeyAccount account;
    private LedgerKeyTrustLine trustLine;
    private LedgerKeyOffer offer;
    private LedgerKeyData data;
    private LedgerKeyClaimableBalance claimableBalance;
    private LedgerKeyLiquidityPool liquidityPool;
    private LedgerKeyContractData contractData;
    private LedgerKeyContractCode contractCode;
    private LedgerKeyConfigSetting configSetting;
    private LedgerKeyTtl ttl;

    public Builder discriminant(LedgerEntryType discriminant) {
      this.discriminant = discriminant;
      return this;
    }

    public Builder account(LedgerKeyAccount account) {
      this.account = account;
      return this;
    }

    public Builder trustLine(LedgerKeyTrustLine trustLine) {
      this.trustLine = trustLine;
      return this;
    }

    public Builder offer(LedgerKeyOffer offer) {
      this.offer = offer;
      return this;
    }

    public Builder data(LedgerKeyData data) {
      this.data = data;
      return this;
    }

    public Builder claimableBalance(LedgerKeyClaimableBalance claimableBalance) {
      this.claimableBalance = claimableBalance;
      return this;
    }

    public Builder liquidityPool(LedgerKeyLiquidityPool liquidityPool) {
      this.liquidityPool = liquidityPool;
      return this;
    }

    public Builder contractData(LedgerKeyContractData contractData) {
      this.contractData = contractData;
      return this;
    }

    public Builder contractCode(LedgerKeyContractCode contractCode) {
      this.contractCode = contractCode;
      return this;
    }

    public Builder configSetting(LedgerKeyConfigSetting configSetting) {
      this.configSetting = configSetting;
      return this;
    }

    public Builder ttl(LedgerKeyTtl ttl) {
      this.ttl = ttl;
      return this;
    }

    public LedgerKey build() {
      LedgerKey val = new LedgerKey();
      val.setDiscriminant(discriminant);
      val.setAccount(this.account);
      val.setTrustLine(this.trustLine);
      val.setOffer(this.offer);
      val.setData(this.data);
      val.setClaimableBalance(this.claimableBalance);
      val.setLiquidityPool(this.liquidityPool);
      val.setContractData(this.contractData);
      val.setContractCode(this.contractCode);
      val.setConfigSetting(this.configSetting);
      val.setTtl(this.ttl);
      return val;
    }
  }

  public static void encode(XdrDataOutputStream stream, LedgerKey encodedLedgerKey)
      throws IOException {
    // Xdrgen::AST::Identifier
    // LedgerEntryType
    stream.writeInt(encodedLedgerKey.getDiscriminant().getValue());
    switch (encodedLedgerKey.getDiscriminant()) {
      case ACCOUNT:
        LedgerKeyAccount.encode(stream, encodedLedgerKey.account);
        break;
      case TRUSTLINE:
        LedgerKeyTrustLine.encode(stream, encodedLedgerKey.trustLine);
        break;
      case OFFER:
        LedgerKeyOffer.encode(stream, encodedLedgerKey.offer);
        break;
      case DATA:
        LedgerKeyData.encode(stream, encodedLedgerKey.data);
        break;
      case CLAIMABLE_BALANCE:
        LedgerKeyClaimableBalance.encode(stream, encodedLedgerKey.claimableBalance);
        break;
      case LIQUIDITY_POOL:
        LedgerKeyLiquidityPool.encode(stream, encodedLedgerKey.liquidityPool);
        break;
      case CONTRACT_DATA:
        LedgerKeyContractData.encode(stream, encodedLedgerKey.contractData);
        break;
      case CONTRACT_CODE:
        LedgerKeyContractCode.encode(stream, encodedLedgerKey.contractCode);
        break;
      case CONFIG_SETTING:
        LedgerKeyConfigSetting.encode(stream, encodedLedgerKey.configSetting);
        break;
      case TTL:
        LedgerKeyTtl.encode(stream, encodedLedgerKey.ttl);
        break;
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static LedgerKey decode(XdrDataInputStream stream) throws IOException {
    LedgerKey decodedLedgerKey = new LedgerKey();
    LedgerEntryType discriminant = LedgerEntryType.decode(stream);
    decodedLedgerKey.setDiscriminant(discriminant);
    switch (decodedLedgerKey.getDiscriminant()) {
      case ACCOUNT:
        decodedLedgerKey.account = LedgerKeyAccount.decode(stream);
        break;
      case TRUSTLINE:
        decodedLedgerKey.trustLine = LedgerKeyTrustLine.decode(stream);
        break;
      case OFFER:
        decodedLedgerKey.offer = LedgerKeyOffer.decode(stream);
        break;
      case DATA:
        decodedLedgerKey.data = LedgerKeyData.decode(stream);
        break;
      case CLAIMABLE_BALANCE:
        decodedLedgerKey.claimableBalance = LedgerKeyClaimableBalance.decode(stream);
        break;
      case LIQUIDITY_POOL:
        decodedLedgerKey.liquidityPool = LedgerKeyLiquidityPool.decode(stream);
        break;
      case CONTRACT_DATA:
        decodedLedgerKey.contractData = LedgerKeyContractData.decode(stream);
        break;
      case CONTRACT_CODE:
        decodedLedgerKey.contractCode = LedgerKeyContractCode.decode(stream);
        break;
      case CONFIG_SETTING:
        decodedLedgerKey.configSetting = LedgerKeyConfigSetting.decode(stream);
        break;
      case TTL:
        decodedLedgerKey.ttl = LedgerKeyTtl.decode(stream);
        break;
    }
    return decodedLedgerKey;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        this.account,
        this.trustLine,
        this.offer,
        this.data,
        this.claimableBalance,
        this.liquidityPool,
        this.contractData,
        this.contractCode,
        this.configSetting,
        this.ttl,
        this.type);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof LedgerKey)) {
      return false;
    }

    LedgerKey other = (LedgerKey) object;
    return Objects.equals(this.account, other.account)
        && Objects.equals(this.trustLine, other.trustLine)
        && Objects.equals(this.offer, other.offer)
        && Objects.equals(this.data, other.data)
        && Objects.equals(this.claimableBalance, other.claimableBalance)
        && Objects.equals(this.liquidityPool, other.liquidityPool)
        && Objects.equals(this.contractData, other.contractData)
        && Objects.equals(this.contractCode, other.contractCode)
        && Objects.equals(this.configSetting, other.configSetting)
        && Objects.equals(this.ttl, other.ttl)
        && Objects.equals(this.type, other.type);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static LedgerKey fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerKey fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static class LedgerKeyAccount implements XdrElement {
    public LedgerKeyAccount() {}

    private AccountID accountID;

    public AccountID getAccountID() {
      return this.accountID;
    }

    public void setAccountID(AccountID value) {
      this.accountID = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerKeyAccount encodedLedgerKeyAccount)
        throws IOException {
      AccountID.encode(stream, encodedLedgerKeyAccount.accountID);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyAccount decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyAccount decodedLedgerKeyAccount = new LedgerKeyAccount();
      decodedLedgerKeyAccount.accountID = AccountID.decode(stream);
      return decodedLedgerKeyAccount;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.accountID);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyAccount)) {
        return false;
      }

      LedgerKeyAccount other = (LedgerKeyAccount) object;
      return Objects.equals(this.accountID, other.accountID);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyAccount fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyAccount fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private AccountID accountID;

      public Builder accountID(AccountID accountID) {
        this.accountID = accountID;
        return this;
      }

      public LedgerKeyAccount build() {
        LedgerKeyAccount val = new LedgerKeyAccount();
        val.setAccountID(this.accountID);
        return val;
      }
    }
  }

  public static class LedgerKeyTrustLine implements XdrElement {
    public LedgerKeyTrustLine() {}

    private AccountID accountID;

    public AccountID getAccountID() {
      return this.accountID;
    }

    public void setAccountID(AccountID value) {
      this.accountID = value;
    }

    private TrustLineAsset asset;

    public TrustLineAsset getAsset() {
      return this.asset;
    }

    public void setAsset(TrustLineAsset value) {
      this.asset = value;
    }

    public static void encode(
        XdrDataOutputStream stream, LedgerKeyTrustLine encodedLedgerKeyTrustLine)
        throws IOException {
      AccountID.encode(stream, encodedLedgerKeyTrustLine.accountID);
      TrustLineAsset.encode(stream, encodedLedgerKeyTrustLine.asset);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyTrustLine decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyTrustLine decodedLedgerKeyTrustLine = new LedgerKeyTrustLine();
      decodedLedgerKeyTrustLine.accountID = AccountID.decode(stream);
      decodedLedgerKeyTrustLine.asset = TrustLineAsset.decode(stream);
      return decodedLedgerKeyTrustLine;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.accountID, this.asset);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyTrustLine)) {
        return false;
      }

      LedgerKeyTrustLine other = (LedgerKeyTrustLine) object;
      return Objects.equals(this.accountID, other.accountID)
          && Objects.equals(this.asset, other.asset);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyTrustLine fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyTrustLine fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private AccountID accountID;
      private TrustLineAsset asset;

      public Builder accountID(AccountID accountID) {
        this.accountID = accountID;
        return this;
      }

      public Builder asset(TrustLineAsset asset) {
        this.asset = asset;
        return this;
      }

      public LedgerKeyTrustLine build() {
        LedgerKeyTrustLine val = new LedgerKeyTrustLine();
        val.setAccountID(this.accountID);
        val.setAsset(this.asset);
        return val;
      }
    }
  }

  public static class LedgerKeyOffer implements XdrElement {
    public LedgerKeyOffer() {}

    private AccountID sellerID;

    public AccountID getSellerID() {
      return this.sellerID;
    }

    public void setSellerID(AccountID value) {
      this.sellerID = value;
    }

    private Int64 offerID;

    public Int64 getOfferID() {
      return this.offerID;
    }

    public void setOfferID(Int64 value) {
      this.offerID = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerKeyOffer encodedLedgerKeyOffer)
        throws IOException {
      AccountID.encode(stream, encodedLedgerKeyOffer.sellerID);
      Int64.encode(stream, encodedLedgerKeyOffer.offerID);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyOffer decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyOffer decodedLedgerKeyOffer = new LedgerKeyOffer();
      decodedLedgerKeyOffer.sellerID = AccountID.decode(stream);
      decodedLedgerKeyOffer.offerID = Int64.decode(stream);
      return decodedLedgerKeyOffer;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.sellerID, this.offerID);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyOffer)) {
        return false;
      }

      LedgerKeyOffer other = (LedgerKeyOffer) object;
      return Objects.equals(this.sellerID, other.sellerID)
          && Objects.equals(this.offerID, other.offerID);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyOffer fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyOffer fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private AccountID sellerID;
      private Int64 offerID;

      public Builder sellerID(AccountID sellerID) {
        this.sellerID = sellerID;
        return this;
      }

      public Builder offerID(Int64 offerID) {
        this.offerID = offerID;
        return this;
      }

      public LedgerKeyOffer build() {
        LedgerKeyOffer val = new LedgerKeyOffer();
        val.setSellerID(this.sellerID);
        val.setOfferID(this.offerID);
        return val;
      }
    }
  }

  public static class LedgerKeyData implements XdrElement {
    public LedgerKeyData() {}

    private AccountID accountID;

    public AccountID getAccountID() {
      return this.accountID;
    }

    public void setAccountID(AccountID value) {
      this.accountID = value;
    }

    private String64 dataName;

    public String64 getDataName() {
      return this.dataName;
    }

    public void setDataName(String64 value) {
      this.dataName = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerKeyData encodedLedgerKeyData)
        throws IOException {
      AccountID.encode(stream, encodedLedgerKeyData.accountID);
      String64.encode(stream, encodedLedgerKeyData.dataName);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyData decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyData decodedLedgerKeyData = new LedgerKeyData();
      decodedLedgerKeyData.accountID = AccountID.decode(stream);
      decodedLedgerKeyData.dataName = String64.decode(stream);
      return decodedLedgerKeyData;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.accountID, this.dataName);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyData)) {
        return false;
      }

      LedgerKeyData other = (LedgerKeyData) object;
      return Objects.equals(this.accountID, other.accountID)
          && Objects.equals(this.dataName, other.dataName);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyData fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyData fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private AccountID accountID;
      private String64 dataName;

      public Builder accountID(AccountID accountID) {
        this.accountID = accountID;
        return this;
      }

      public Builder dataName(String64 dataName) {
        this.dataName = dataName;
        return this;
      }

      public LedgerKeyData build() {
        LedgerKeyData val = new LedgerKeyData();
        val.setAccountID(this.accountID);
        val.setDataName(this.dataName);
        return val;
      }
    }
  }

  public static class LedgerKeyClaimableBalance implements XdrElement {
    public LedgerKeyClaimableBalance() {}

    private ClaimableBalanceID balanceID;

    public ClaimableBalanceID getBalanceID() {
      return this.balanceID;
    }

    public void setBalanceID(ClaimableBalanceID value) {
      this.balanceID = value;
    }

    public static void encode(
        XdrDataOutputStream stream, LedgerKeyClaimableBalance encodedLedgerKeyClaimableBalance)
        throws IOException {
      ClaimableBalanceID.encode(stream, encodedLedgerKeyClaimableBalance.balanceID);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyClaimableBalance decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyClaimableBalance decodedLedgerKeyClaimableBalance = new LedgerKeyClaimableBalance();
      decodedLedgerKeyClaimableBalance.balanceID = ClaimableBalanceID.decode(stream);
      return decodedLedgerKeyClaimableBalance;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.balanceID);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyClaimableBalance)) {
        return false;
      }

      LedgerKeyClaimableBalance other = (LedgerKeyClaimableBalance) object;
      return Objects.equals(this.balanceID, other.balanceID);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyClaimableBalance fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyClaimableBalance fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private ClaimableBalanceID balanceID;

      public Builder balanceID(ClaimableBalanceID balanceID) {
        this.balanceID = balanceID;
        return this;
      }

      public LedgerKeyClaimableBalance build() {
        LedgerKeyClaimableBalance val = new LedgerKeyClaimableBalance();
        val.setBalanceID(this.balanceID);
        return val;
      }
    }
  }

  public static class LedgerKeyLiquidityPool implements XdrElement {
    public LedgerKeyLiquidityPool() {}

    private PoolID liquidityPoolID;

    public PoolID getLiquidityPoolID() {
      return this.liquidityPoolID;
    }

    public void setLiquidityPoolID(PoolID value) {
      this.liquidityPoolID = value;
    }

    public static void encode(
        XdrDataOutputStream stream, LedgerKeyLiquidityPool encodedLedgerKeyLiquidityPool)
        throws IOException {
      PoolID.encode(stream, encodedLedgerKeyLiquidityPool.liquidityPoolID);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyLiquidityPool decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyLiquidityPool decodedLedgerKeyLiquidityPool = new LedgerKeyLiquidityPool();
      decodedLedgerKeyLiquidityPool.liquidityPoolID = PoolID.decode(stream);
      return decodedLedgerKeyLiquidityPool;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.liquidityPoolID);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyLiquidityPool)) {
        return false;
      }

      LedgerKeyLiquidityPool other = (LedgerKeyLiquidityPool) object;
      return Objects.equals(this.liquidityPoolID, other.liquidityPoolID);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyLiquidityPool fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyLiquidityPool fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private PoolID liquidityPoolID;

      public Builder liquidityPoolID(PoolID liquidityPoolID) {
        this.liquidityPoolID = liquidityPoolID;
        return this;
      }

      public LedgerKeyLiquidityPool build() {
        LedgerKeyLiquidityPool val = new LedgerKeyLiquidityPool();
        val.setLiquidityPoolID(this.liquidityPoolID);
        return val;
      }
    }
  }

  public static class LedgerKeyContractData implements XdrElement {
    public LedgerKeyContractData() {}

    private SCAddress contract;

    public SCAddress getContract() {
      return this.contract;
    }

    public void setContract(SCAddress value) {
      this.contract = value;
    }

    private SCVal key;

    public SCVal getKey() {
      return this.key;
    }

    public void setKey(SCVal value) {
      this.key = value;
    }

    private ContractDataDurability durability;

    public ContractDataDurability getDurability() {
      return this.durability;
    }

    public void setDurability(ContractDataDurability value) {
      this.durability = value;
    }

    public static void encode(
        XdrDataOutputStream stream, LedgerKeyContractData encodedLedgerKeyContractData)
        throws IOException {
      SCAddress.encode(stream, encodedLedgerKeyContractData.contract);
      SCVal.encode(stream, encodedLedgerKeyContractData.key);
      ContractDataDurability.encode(stream, encodedLedgerKeyContractData.durability);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyContractData decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyContractData decodedLedgerKeyContractData = new LedgerKeyContractData();
      decodedLedgerKeyContractData.contract = SCAddress.decode(stream);
      decodedLedgerKeyContractData.key = SCVal.decode(stream);
      decodedLedgerKeyContractData.durability = ContractDataDurability.decode(stream);
      return decodedLedgerKeyContractData;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.contract, this.key, this.durability);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyContractData)) {
        return false;
      }

      LedgerKeyContractData other = (LedgerKeyContractData) object;
      return Objects.equals(this.contract, other.contract)
          && Objects.equals(this.key, other.key)
          && Objects.equals(this.durability, other.durability);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyContractData fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyContractData fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private SCAddress contract;
      private SCVal key;
      private ContractDataDurability durability;

      public Builder contract(SCAddress contract) {
        this.contract = contract;
        return this;
      }

      public Builder key(SCVal key) {
        this.key = key;
        return this;
      }

      public Builder durability(ContractDataDurability durability) {
        this.durability = durability;
        return this;
      }

      public LedgerKeyContractData build() {
        LedgerKeyContractData val = new LedgerKeyContractData();
        val.setContract(this.contract);
        val.setKey(this.key);
        val.setDurability(this.durability);
        return val;
      }
    }
  }

  public static class LedgerKeyContractCode implements XdrElement {
    public LedgerKeyContractCode() {}

    private Hash hash;

    public Hash getHash() {
      return this.hash;
    }

    public void setHash(Hash value) {
      this.hash = value;
    }

    public static void encode(
        XdrDataOutputStream stream, LedgerKeyContractCode encodedLedgerKeyContractCode)
        throws IOException {
      Hash.encode(stream, encodedLedgerKeyContractCode.hash);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyContractCode decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyContractCode decodedLedgerKeyContractCode = new LedgerKeyContractCode();
      decodedLedgerKeyContractCode.hash = Hash.decode(stream);
      return decodedLedgerKeyContractCode;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.hash);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyContractCode)) {
        return false;
      }

      LedgerKeyContractCode other = (LedgerKeyContractCode) object;
      return Objects.equals(this.hash, other.hash);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyContractCode fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyContractCode fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private Hash hash;

      public Builder hash(Hash hash) {
        this.hash = hash;
        return this;
      }

      public LedgerKeyContractCode build() {
        LedgerKeyContractCode val = new LedgerKeyContractCode();
        val.setHash(this.hash);
        return val;
      }
    }
  }

  public static class LedgerKeyConfigSetting implements XdrElement {
    public LedgerKeyConfigSetting() {}

    private ConfigSettingID configSettingID;

    public ConfigSettingID getConfigSettingID() {
      return this.configSettingID;
    }

    public void setConfigSettingID(ConfigSettingID value) {
      this.configSettingID = value;
    }

    public static void encode(
        XdrDataOutputStream stream, LedgerKeyConfigSetting encodedLedgerKeyConfigSetting)
        throws IOException {
      ConfigSettingID.encode(stream, encodedLedgerKeyConfigSetting.configSettingID);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyConfigSetting decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyConfigSetting decodedLedgerKeyConfigSetting = new LedgerKeyConfigSetting();
      decodedLedgerKeyConfigSetting.configSettingID = ConfigSettingID.decode(stream);
      return decodedLedgerKeyConfigSetting;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.configSettingID);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyConfigSetting)) {
        return false;
      }

      LedgerKeyConfigSetting other = (LedgerKeyConfigSetting) object;
      return Objects.equals(this.configSettingID, other.configSettingID);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyConfigSetting fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyConfigSetting fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private ConfigSettingID configSettingID;

      public Builder configSettingID(ConfigSettingID configSettingID) {
        this.configSettingID = configSettingID;
        return this;
      }

      public LedgerKeyConfigSetting build() {
        LedgerKeyConfigSetting val = new LedgerKeyConfigSetting();
        val.setConfigSettingID(this.configSettingID);
        return val;
      }
    }
  }

  public static class LedgerKeyTtl implements XdrElement {
    public LedgerKeyTtl() {}

    private Hash keyHash;

    public Hash getKeyHash() {
      return this.keyHash;
    }

    public void setKeyHash(Hash value) {
      this.keyHash = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerKeyTtl encodedLedgerKeyTtl)
        throws IOException {
      Hash.encode(stream, encodedLedgerKeyTtl.keyHash);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerKeyTtl decode(XdrDataInputStream stream) throws IOException {
      LedgerKeyTtl decodedLedgerKeyTtl = new LedgerKeyTtl();
      decodedLedgerKeyTtl.keyHash = Hash.decode(stream);
      return decodedLedgerKeyTtl;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.keyHash);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerKeyTtl)) {
        return false;
      }

      LedgerKeyTtl other = (LedgerKeyTtl) object;
      return Objects.equals(this.keyHash, other.keyHash);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKeyTtl fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerKeyTtl fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private Hash keyHash;

      public Builder keyHash(Hash keyHash) {
        this.keyHash = keyHash;
        return this;
      }

      public LedgerKeyTtl build() {
        LedgerKeyTtl val = new LedgerKeyTtl();
        val.setKeyHash(this.keyHash);
        return val;
      }
    }
  }
}
