// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct PeerAddress
//  {
//      union switch (IPAddrType type)
//      {
//      case IPv4:
//          opaque ipv4[4];
//      case IPv6:
//          opaque ipv6[16];
//      }
//      ip;
//      uint32 port;
//      uint32 numFailures;
//  };

//  ===========================================================================
public class PeerAddress implements XdrElement {
  public PeerAddress() {}

  private PeerAddressIp ip;

  public PeerAddressIp getIp() {
    return this.ip;
  }

  public void setIp(PeerAddressIp value) {
    this.ip = value;
  }

  private Uint32 port;

  public Uint32 getPort() {
    return this.port;
  }

  public void setPort(Uint32 value) {
    this.port = value;
  }

  private Uint32 numFailures;

  public Uint32 getNumFailures() {
    return this.numFailures;
  }

  public void setNumFailures(Uint32 value) {
    this.numFailures = value;
  }

  public static void encode(XdrDataOutputStream stream, PeerAddress encodedPeerAddress)
      throws IOException {
    PeerAddressIp.encode(stream, encodedPeerAddress.ip);
    Uint32.encode(stream, encodedPeerAddress.port);
    Uint32.encode(stream, encodedPeerAddress.numFailures);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static PeerAddress decode(XdrDataInputStream stream) throws IOException {
    PeerAddress decodedPeerAddress = new PeerAddress();
    decodedPeerAddress.ip = PeerAddressIp.decode(stream);
    decodedPeerAddress.port = Uint32.decode(stream);
    decodedPeerAddress.numFailures = Uint32.decode(stream);
    return decodedPeerAddress;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.ip, this.port, this.numFailures);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof PeerAddress)) {
      return false;
    }

    PeerAddress other = (PeerAddress) object;
    return Objects.equals(this.ip, other.ip)
        && Objects.equals(this.port, other.port)
        && Objects.equals(this.numFailures, other.numFailures);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static PeerAddress fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PeerAddress fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private PeerAddressIp ip;
    private Uint32 port;
    private Uint32 numFailures;

    public Builder ip(PeerAddressIp ip) {
      this.ip = ip;
      return this;
    }

    public Builder port(Uint32 port) {
      this.port = port;
      return this;
    }

    public Builder numFailures(Uint32 numFailures) {
      this.numFailures = numFailures;
      return this;
    }

    public PeerAddress build() {
      PeerAddress val = new PeerAddress();
      val.setIp(this.ip);
      val.setPort(this.port);
      val.setNumFailures(this.numFailures);
      return val;
    }
  }

  public static class PeerAddressIp implements XdrElement {
    public PeerAddressIp() {}

    IPAddrType type;

    public IPAddrType getDiscriminant() {
      return this.type;
    }

    public void setDiscriminant(IPAddrType value) {
      this.type = value;
    }

    private byte[] ipv4;

    public byte[] getIpv4() {
      return this.ipv4;
    }

    public void setIpv4(byte[] value) {
      this.ipv4 = value;
    }

    private byte[] ipv6;

    public byte[] getIpv6() {
      return this.ipv6;
    }

    public void setIpv6(byte[] value) {
      this.ipv6 = value;
    }

    public static final class Builder {
      private IPAddrType discriminant;
      private byte[] ipv4;
      private byte[] ipv6;

      public Builder discriminant(IPAddrType discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder ipv4(byte[] ipv4) {
        this.ipv4 = ipv4;
        return this;
      }

      public Builder ipv6(byte[] ipv6) {
        this.ipv6 = ipv6;
        return this;
      }

      public PeerAddressIp build() {
        PeerAddressIp val = new PeerAddressIp();
        val.setDiscriminant(discriminant);
        val.setIpv4(this.ipv4);
        val.setIpv6(this.ipv6);
        return val;
      }
    }

    public static void encode(XdrDataOutputStream stream, PeerAddressIp encodedPeerAddressIp)
        throws IOException {
      // Xdrgen::AST::Identifier
      // IPAddrType
      stream.writeInt(encodedPeerAddressIp.getDiscriminant().getValue());
      switch (encodedPeerAddressIp.getDiscriminant()) {
        case IPv4:
          int ipv4size = encodedPeerAddressIp.ipv4.length;
          stream.write(encodedPeerAddressIp.getIpv4(), 0, ipv4size);
          break;
        case IPv6:
          int ipv6size = encodedPeerAddressIp.ipv6.length;
          stream.write(encodedPeerAddressIp.getIpv6(), 0, ipv6size);
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static PeerAddressIp decode(XdrDataInputStream stream) throws IOException {
      PeerAddressIp decodedPeerAddressIp = new PeerAddressIp();
      IPAddrType discriminant = IPAddrType.decode(stream);
      decodedPeerAddressIp.setDiscriminant(discriminant);
      switch (decodedPeerAddressIp.getDiscriminant()) {
        case IPv4:
          int ipv4size = 4;
          decodedPeerAddressIp.ipv4 = new byte[ipv4size];
          stream.read(decodedPeerAddressIp.ipv4, 0, ipv4size);
          break;
        case IPv6:
          int ipv6size = 16;
          decodedPeerAddressIp.ipv6 = new byte[ipv6size];
          stream.read(decodedPeerAddressIp.ipv6, 0, ipv6size);
          break;
      }
      return decodedPeerAddressIp;
    }

    @Override
    public int hashCode() {
      return Objects.hash(Arrays.hashCode(this.ipv4), Arrays.hashCode(this.ipv6), this.type);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof PeerAddressIp)) {
        return false;
      }

      PeerAddressIp other = (PeerAddressIp) object;
      return Arrays.equals(this.ipv4, other.ipv4)
          && Arrays.equals(this.ipv6, other.ipv6)
          && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static PeerAddressIp fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static PeerAddressIp fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
