// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct SCPHistoryEntryV0
//  {
//      SCPQuorumSet quorumSets<>; // additional quorum sets used by ledgerMessages
//      LedgerSCPMessages ledgerMessages;
//  };

//  ===========================================================================
public class SCPHistoryEntryV0 implements XdrElement {
  public SCPHistoryEntryV0() {}

  private SCPQuorumSet[] quorumSets;

  public SCPQuorumSet[] getQuorumSets() {
    return this.quorumSets;
  }

  public void setQuorumSets(SCPQuorumSet[] value) {
    this.quorumSets = value;
  }

  private LedgerSCPMessages ledgerMessages;

  public LedgerSCPMessages getLedgerMessages() {
    return this.ledgerMessages;
  }

  public void setLedgerMessages(LedgerSCPMessages value) {
    this.ledgerMessages = value;
  }

  public static void encode(XdrDataOutputStream stream, SCPHistoryEntryV0 encodedSCPHistoryEntryV0)
      throws IOException {
    int quorumSetssize = encodedSCPHistoryEntryV0.getQuorumSets().length;
    stream.writeInt(quorumSetssize);
    for (int i = 0; i < quorumSetssize; i++) {
      SCPQuorumSet.encode(stream, encodedSCPHistoryEntryV0.quorumSets[i]);
    }
    LedgerSCPMessages.encode(stream, encodedSCPHistoryEntryV0.ledgerMessages);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static SCPHistoryEntryV0 decode(XdrDataInputStream stream) throws IOException {
    SCPHistoryEntryV0 decodedSCPHistoryEntryV0 = new SCPHistoryEntryV0();
    int quorumSetssize = stream.readInt();
    decodedSCPHistoryEntryV0.quorumSets = new SCPQuorumSet[quorumSetssize];
    for (int i = 0; i < quorumSetssize; i++) {
      decodedSCPHistoryEntryV0.quorumSets[i] = SCPQuorumSet.decode(stream);
    }
    decodedSCPHistoryEntryV0.ledgerMessages = LedgerSCPMessages.decode(stream);
    return decodedSCPHistoryEntryV0;
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(this.quorumSets), this.ledgerMessages);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof SCPHistoryEntryV0)) {
      return false;
    }

    SCPHistoryEntryV0 other = (SCPHistoryEntryV0) object;
    return Arrays.equals(this.quorumSets, other.quorumSets)
        && Objects.equals(this.ledgerMessages, other.ledgerMessages);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static SCPHistoryEntryV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPHistoryEntryV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private SCPQuorumSet[] quorumSets;
    private LedgerSCPMessages ledgerMessages;

    public Builder quorumSets(SCPQuorumSet[] quorumSets) {
      this.quorumSets = quorumSets;
      return this;
    }

    public Builder ledgerMessages(LedgerSCPMessages ledgerMessages) {
      this.ledgerMessages = ledgerMessages;
      return this;
    }

    public SCPHistoryEntryV0 build() {
      SCPHistoryEntryV0 val = new SCPHistoryEntryV0();
      val.setQuorumSets(this.quorumSets);
      val.setLedgerMessages(this.ledgerMessages);
      return val;
    }
  }
}
