// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct TransactionSet
//  {
//      Hash previousLedgerHash;
//      TransactionEnvelope txs<>;
//  };

//  ===========================================================================
public class TransactionSet implements XdrElement {
  public TransactionSet() {}

  private Hash previousLedgerHash;

  public Hash getPreviousLedgerHash() {
    return this.previousLedgerHash;
  }

  public void setPreviousLedgerHash(Hash value) {
    this.previousLedgerHash = value;
  }

  private TransactionEnvelope[] txs;

  public TransactionEnvelope[] getTxs() {
    return this.txs;
  }

  public void setTxs(TransactionEnvelope[] value) {
    this.txs = value;
  }

  public static void encode(XdrDataOutputStream stream, TransactionSet encodedTransactionSet)
      throws IOException {
    Hash.encode(stream, encodedTransactionSet.previousLedgerHash);
    int txssize = encodedTransactionSet.getTxs().length;
    stream.writeInt(txssize);
    for (int i = 0; i < txssize; i++) {
      TransactionEnvelope.encode(stream, encodedTransactionSet.txs[i]);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static TransactionSet decode(XdrDataInputStream stream) throws IOException {
    TransactionSet decodedTransactionSet = new TransactionSet();
    decodedTransactionSet.previousLedgerHash = Hash.decode(stream);
    int txssize = stream.readInt();
    decodedTransactionSet.txs = new TransactionEnvelope[txssize];
    for (int i = 0; i < txssize; i++) {
      decodedTransactionSet.txs[i] = TransactionEnvelope.decode(stream);
    }
    return decodedTransactionSet;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.previousLedgerHash, Arrays.hashCode(this.txs));
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof TransactionSet)) {
      return false;
    }

    TransactionSet other = (TransactionSet) object;
    return Objects.equals(this.previousLedgerHash, other.previousLedgerHash)
        && Arrays.equals(this.txs, other.txs);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static TransactionSet fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Hash previousLedgerHash;
    private TransactionEnvelope[] txs;

    public Builder previousLedgerHash(Hash previousLedgerHash) {
      this.previousLedgerHash = previousLedgerHash;
      return this;
    }

    public Builder txs(TransactionEnvelope[] txs) {
      this.txs = txs;
      return this;
    }

    public TransactionSet build() {
      TransactionSet val = new TransactionSet();
      val.setPreviousLedgerHash(this.previousLedgerHash);
      val.setTxs(this.txs);
      return val;
    }
  }
}
