/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.TrustLineAsset;

public final class LiquidityPoolShareTrustLineAsset
extends org.stellar.sdk.TrustLineAsset {
    @NonNull
    private final LiquidityPoolID id;

    public LiquidityPoolShareTrustLineAsset(@NonNull LiquidityPoolParameters params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        this.id = params.getId();
    }

    public LiquidityPoolID getLiquidityPoolID() {
        return this.id;
    }

    @Override
    public String getType() {
        return "pool_share";
    }

    public String toString() {
        return this.getLiquidityPoolID().toString();
    }

    @Override
    public int compareTo(@NonNull org.stellar.sdk.TrustLineAsset other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (!Objects.equals(other.getType(), "pool_share")) {
            return 1;
        }
        return this.toString().compareTo(((LiquidityPoolShareTrustLineAsset)other).toString());
    }

    @Override
    public TrustLineAsset toXdr() {
        TrustLineAsset xdr = new TrustLineAsset();
        xdr.setDiscriminant(AssetType.ASSET_TYPE_POOL_SHARE);
        xdr.setLiquidityPoolID(this.id.toXdr());
        return xdr;
    }

    @Generated
    public LiquidityPoolShareTrustLineAsset(@NonNull LiquidityPoolID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolShareTrustLineAsset)) {
            return false;
        }
        LiquidityPoolShareTrustLineAsset other = (LiquidityPoolShareTrustLineAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LiquidityPoolID this$id = this.id;
        LiquidityPoolID other$id = other.id;
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolShareTrustLineAsset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LiquidityPoolID $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

