/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictSendOp;

public class PathPaymentStrictSendOperation
extends Operation {
    @NonNull
    private final Asset sendAsset;
    @NonNull
    private final String sendAmount;
    @NonNull
    private final String destination;
    @NonNull
    private final Asset destAsset;
    @NonNull
    private final String destMin;
    private final Asset[] path;

    private PathPaymentStrictSendOperation(@NonNull Asset sendAsset, @NonNull String sendAmount, @NonNull String destination, @NonNull Asset destAsset, @NonNull String destMin, Asset[] path) {
        if (sendAsset == null) {
            throw new NullPointerException("sendAsset is marked non-null but is null");
        }
        if (sendAmount == null) {
            throw new NullPointerException("sendAmount is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (destAsset == null) {
            throw new NullPointerException("destAsset is marked non-null but is null");
        }
        if (destMin == null) {
            throw new NullPointerException("destMin is marked non-null but is null");
        }
        this.sendAsset = sendAsset;
        this.sendAmount = sendAmount;
        this.destination = destination;
        this.destAsset = destAsset;
        this.destMin = destMin;
        if (path == null) {
            this.path = new Asset[0];
        } else {
            if (path.length > 5) {
                throw new IllegalArgumentException("The maximum number of assets in the path is 5");
            }
            this.path = path;
        }
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        PathPaymentStrictSendOp op = new PathPaymentStrictSendOp();
        op.setSendAsset(this.sendAsset.toXdr());
        Int64 sendAmount = new Int64();
        sendAmount.setInt64(Operation.toXdrAmount(this.sendAmount));
        op.setSendAmount(sendAmount);
        op.setDestination(accountConverter.encode(this.destination));
        op.setDestAsset(this.destAsset.toXdr());
        Int64 destMin = new Int64();
        destMin.setInt64(Operation.toXdrAmount(this.destMin));
        op.setDestMin(destMin);
        org.stellar.sdk.xdr.Asset[] path = new org.stellar.sdk.xdr.Asset[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            path[i] = this.path[i].toXdr();
        }
        op.setPath(path);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PATH_PAYMENT_STRICT_SEND);
        body.setPathPaymentStrictSendOp(op);
        return body;
    }

    @NonNull
    @Generated
    public Asset getSendAsset() {
        return this.sendAsset;
    }

    @NonNull
    @Generated
    public String getSendAmount() {
        return this.sendAmount;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Asset getDestAsset() {
        return this.destAsset;
    }

    @NonNull
    @Generated
    public String getDestMin() {
        return this.destMin;
    }

    @Generated
    public Asset[] getPath() {
        return this.path;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictSendOperation)) {
            return false;
        }
        PathPaymentStrictSendOperation other = (PathPaymentStrictSendOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset this$sendAsset = this.getSendAsset();
        Asset other$sendAsset = other.getSendAsset();
        if (this$sendAsset == null ? other$sendAsset != null : !((Object)this$sendAsset).equals(other$sendAsset)) {
            return false;
        }
        String this$sendAmount = this.getSendAmount();
        String other$sendAmount = other.getSendAmount();
        if (this$sendAmount == null ? other$sendAmount != null : !this$sendAmount.equals(other$sendAmount)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Asset this$destAsset = this.getDestAsset();
        Asset other$destAsset = other.getDestAsset();
        if (this$destAsset == null ? other$destAsset != null : !((Object)this$destAsset).equals(other$destAsset)) {
            return false;
        }
        String this$destMin = this.getDestMin();
        String other$destMin = other.getDestMin();
        if (this$destMin == null ? other$destMin != null : !this$destMin.equals(other$destMin)) {
            return false;
        }
        return Arrays.deepEquals(this.getPath(), other.getPath());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictSendOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Asset $sendAsset = this.getSendAsset();
        result = result * 59 + ($sendAsset == null ? 43 : $sendAsset.hashCode());
        String $sendAmount = this.getSendAmount();
        result = result * 59 + ($sendAmount == null ? 43 : $sendAmount.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Asset $destAsset = this.getDestAsset();
        result = result * 59 + ($destAsset == null ? 43 : $destAsset.hashCode());
        String $destMin = this.getDestMin();
        result = result * 59 + ($destMin == null ? 43 : $destMin.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        return result;
    }

    public static class Builder {
        private final Asset sendAsset;
        private final String sendAmount;
        private final String destination;
        private final Asset destAsset;
        private final String destMin;
        private Asset[] path;
        private String sourceAccount;

        Builder(AccountConverter accountConverter, PathPaymentStrictSendOp op) {
            this.sendAsset = Asset.fromXdr(op.getSendAsset());
            this.sendAmount = Operation.fromXdrAmount(op.getSendAmount().getInt64());
            this.destination = accountConverter.decode(op.getDestination());
            this.destAsset = Asset.fromXdr(op.getDestAsset());
            this.destMin = Operation.fromXdrAmount(op.getDestMin().getInt64());
            this.path = new Asset[op.getPath().length];
            for (int i = 0; i < op.getPath().length; ++i) {
                this.path[i] = Asset.fromXdr(op.getPath()[i]);
            }
        }

        public Builder(@NonNull Asset sendAsset, @NonNull String sendAmount, @NonNull String destination, @NonNull Asset destAsset, @NonNull String destMin) {
            if (sendAsset == null) {
                throw new NullPointerException("sendAsset is marked non-null but is null");
            }
            if (sendAmount == null) {
                throw new NullPointerException("sendAmount is marked non-null but is null");
            }
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            if (destAsset == null) {
                throw new NullPointerException("destAsset is marked non-null but is null");
            }
            if (destMin == null) {
                throw new NullPointerException("destMin is marked non-null but is null");
            }
            this.sendAsset = sendAsset;
            this.sendAmount = sendAmount;
            this.destination = destination;
            this.destAsset = destAsset;
            this.destMin = destMin;
        }

        public Builder setPath(@NonNull Asset[] path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (path.length > 5) {
                throw new IllegalArgumentException("The maximum number of assets in the path is 5");
            }
            this.path = path;
            return this;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public PathPaymentStrictSendOperation build() {
            PathPaymentStrictSendOperation operation = new PathPaymentStrictSendOperation(this.sendAsset, this.sendAmount, this.destination, this.destAsset, this.destMin, this.path);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

