/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.SignerKey;

public class RevokeSignerSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;
    @NonNull
    private final SignerKey signer;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        RevokeSponsorshipOp.RevokeSponsorshipOpSigner xdrSigner = new RevokeSponsorshipOp.RevokeSponsorshipOpSigner();
        xdrSigner.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        xdrSigner.setSignerKey(this.signer);
        op.setSigner(xdrSigner);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_SIGNER);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @NonNull
    @Generated
    public SignerKey getSigner() {
        return this.signer;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeSignerSponsorshipOperation)) {
            return false;
        }
        RevokeSignerSponsorshipOperation other = (RevokeSignerSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        SignerKey this$signer = this.getSigner();
        SignerKey other$signer = other.getSigner();
        return !(this$signer == null ? other$signer != null : !((Object)this$signer).equals(other$signer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeSignerSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        SignerKey $signer = this.getSigner();
        result = result * 59 + ($signer == null ? 43 : ((Object)$signer).hashCode());
        return result;
    }

    @Generated
    private RevokeSignerSponsorshipOperation(@NonNull String accountId, @NonNull SignerKey signer) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        this.accountId = accountId;
        this.signer = signer;
    }

    public static class Builder {
        private final String accountId;
        private final SignerKey signer;
        private String sourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeEd25519PublicKey(op.getSigner().getAccountID());
            this.signer = op.getSigner().getSignerKey();
        }

        public Builder(String accountId, SignerKey signer) {
            this.accountId = accountId;
            this.signer = signer;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public RevokeSignerSponsorshipOperation build() {
            RevokeSignerSponsorshipOperation operation = new RevokeSignerSponsorshipOperation(this.accountId, this.signer);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

