/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TrustLineAsset;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeTrustlineSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;
    @NonNull
    private final TrustLineAsset asset;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.TRUSTLINE);
        LedgerKey.LedgerKeyTrustLine trustLine = new LedgerKey.LedgerKeyTrustLine();
        trustLine.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        trustLine.setAsset(this.asset.toXdr());
        key.setTrustLine(trustLine);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @NonNull
    @Generated
    public TrustLineAsset getAsset() {
        return this.asset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeTrustlineSponsorshipOperation)) {
            return false;
        }
        RevokeTrustlineSponsorshipOperation other = (RevokeTrustlineSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        TrustLineAsset this$asset = this.getAsset();
        TrustLineAsset other$asset = other.getAsset();
        return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeTrustlineSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        TrustLineAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        return result;
    }

    @Generated
    private RevokeTrustlineSponsorshipOperation(@NonNull String accountId, @NonNull TrustLineAsset asset) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.accountId = accountId;
        this.asset = asset;
    }

    public static class Builder {
        private final String accountId;
        private final TrustLineAsset asset;
        private String sourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getTrustLine().getAccountID());
            this.asset = TrustLineAsset.fromXdr(op.getLedgerKey().getTrustLine().getAsset());
        }

        public Builder(String accountId, TrustLineAsset asset) {
            this.accountId = accountId;
            this.asset = asset;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public RevokeTrustlineSponsorshipOperation build() {
            RevokeTrustlineSponsorshipOperation operation = new RevokeTrustlineSponsorshipOperation(this.accountId, this.asset);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

