/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.NonNull;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.SignedPayloadSigner;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.SignerKeyType;
import org.stellar.sdk.xdr.Uint256;

public class Signer {
    public static SignerKey ed25519PublicKey(@NonNull KeyPair keyPair) {
        if (keyPair == null) {
            throw new NullPointerException("keyPair is marked non-null but is null");
        }
        return keyPair.getXdrSignerKey();
    }

    public static SignerKey sha256Hash(byte @NonNull [] hash) {
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        SignerKey signerKey = new SignerKey();
        Uint256 value = Signer.createUint256(hash);
        signerKey.setDiscriminant(SignerKeyType.SIGNER_KEY_TYPE_HASH_X);
        signerKey.setHashX(value);
        return signerKey;
    }

    public static SignerKey preAuthTx(@NonNull Transaction tx) {
        if (tx == null) {
            throw new NullPointerException("tx is marked non-null but is null");
        }
        SignerKey signerKey = new SignerKey();
        Uint256 value = Signer.createUint256(tx.hash());
        signerKey.setDiscriminant(SignerKeyType.SIGNER_KEY_TYPE_PRE_AUTH_TX);
        signerKey.setPreAuthTx(value);
        return signerKey;
    }

    public static SignerKey preAuthTx(byte @NonNull [] hash) {
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        SignerKey signerKey = new SignerKey();
        Uint256 value = Signer.createUint256(hash);
        signerKey.setDiscriminant(SignerKeyType.SIGNER_KEY_TYPE_PRE_AUTH_TX);
        signerKey.setPreAuthTx(value);
        return signerKey;
    }

    public static SignerKey signedPayload(SignedPayloadSigner signedPayloadSigner) {
        SignerKey signerKey = new SignerKey();
        SignerKey.SignerKeyEd25519SignedPayload payloadSigner = new SignerKey.SignerKeyEd25519SignedPayload();
        payloadSigner.setPayload(signedPayloadSigner.getPayload());
        payloadSigner.setEd25519(signedPayloadSigner.getSignerAccountId().getAccountID().getEd25519());
        signerKey.setDiscriminant(SignerKeyType.SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD);
        signerKey.setEd25519SignedPayload(payloadSigner);
        return signerKey;
    }

    private static Uint256 createUint256(byte[] hash) {
        if (hash.length != 32) {
            throw new RuntimeException("hash must be 32 bytes long");
        }
        Uint256 value = new Uint256();
        value.setUint256(hash);
        return value;
    }
}

