/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;

public abstract class PathPaymentBaseOperationResponse
extends OperationResponse {
    @SerializedName(value="amount")
    private String amount;
    @SerializedName(value="source_amount")
    private String sourceAmount;
    @SerializedName(value="from")
    private String from;
    @SerializedName(value="from_muxed")
    private String fromMuxed;
    @SerializedName(value="from_muxed_id")
    private BigInteger fromMuxedId;
    @SerializedName(value="to")
    private String to;
    @SerializedName(value="to_muxed")
    private String toMuxed;
    @SerializedName(value="to_muxed_id")
    private BigInteger toMuxedId;
    @SerializedName(value="asset_type")
    private String assetType;
    @SerializedName(value="asset_code")
    private String assetCode;
    @SerializedName(value="asset_issuer")
    private String assetIssuer;
    @SerializedName(value="source_asset_type")
    private String sourceAssetType;
    @SerializedName(value="source_asset_code")
    private String sourceAssetCode;
    @SerializedName(value="source_asset_issuer")
    private String sourceAssetIssuer;
    @SerializedName(value="path")
    private List<Asset> path;

    public Optional<MuxedAccount> getFromMuxed() {
        if (this.fromMuxed == null || this.fromMuxed.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MuxedAccount(this.fromMuxed, this.from, this.fromMuxedId));
    }

    public Optional<MuxedAccount> getToMuxed() {
        if (this.toMuxed == null || this.toMuxed.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MuxedAccount(this.toMuxed, this.to, this.toMuxedId));
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    public Asset getSourceAsset() {
        if (this.sourceAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.create(this.sourceAssetType, this.sourceAssetCode, this.sourceAssetIssuer);
    }

    @Generated
    public String getAmount() {
        return this.amount;
    }

    @Generated
    public String getSourceAmount() {
        return this.sourceAmount;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public BigInteger getFromMuxedId() {
        return this.fromMuxedId;
    }

    @Generated
    public String getTo() {
        return this.to;
    }

    @Generated
    public BigInteger getToMuxedId() {
        return this.toMuxedId;
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    @Generated
    public String getSourceAssetType() {
        return this.sourceAssetType;
    }

    @Generated
    public String getSourceAssetCode() {
        return this.sourceAssetCode;
    }

    @Generated
    public String getSourceAssetIssuer() {
        return this.sourceAssetIssuer;
    }

    @Generated
    public List<Asset> getPath() {
        return this.path;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentBaseOperationResponse)) {
            return false;
        }
        PathPaymentBaseOperationResponse other = (PathPaymentBaseOperationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$sourceAmount = this.getSourceAmount();
        String other$sourceAmount = other.getSourceAmount();
        if (this$sourceAmount == null ? other$sourceAmount != null : !this$sourceAmount.equals(other$sourceAmount)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Optional<MuxedAccount> this$fromMuxed = this.getFromMuxed();
        Optional<MuxedAccount> other$fromMuxed = other.getFromMuxed();
        if (this$fromMuxed == null ? other$fromMuxed != null : !((Object)this$fromMuxed).equals(other$fromMuxed)) {
            return false;
        }
        BigInteger this$fromMuxedId = this.getFromMuxedId();
        BigInteger other$fromMuxedId = other.getFromMuxedId();
        if (this$fromMuxedId == null ? other$fromMuxedId != null : !((Object)this$fromMuxedId).equals(other$fromMuxedId)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Optional<MuxedAccount> this$toMuxed = this.getToMuxed();
        Optional<MuxedAccount> other$toMuxed = other.getToMuxed();
        if (this$toMuxed == null ? other$toMuxed != null : !((Object)this$toMuxed).equals(other$toMuxed)) {
            return false;
        }
        BigInteger this$toMuxedId = this.getToMuxedId();
        BigInteger other$toMuxedId = other.getToMuxedId();
        if (this$toMuxedId == null ? other$toMuxedId != null : !((Object)this$toMuxedId).equals(other$toMuxedId)) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        String this$assetIssuer = this.getAssetIssuer();
        String other$assetIssuer = other.getAssetIssuer();
        if (this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer)) {
            return false;
        }
        String this$sourceAssetType = this.getSourceAssetType();
        String other$sourceAssetType = other.getSourceAssetType();
        if (this$sourceAssetType == null ? other$sourceAssetType != null : !this$sourceAssetType.equals(other$sourceAssetType)) {
            return false;
        }
        String this$sourceAssetCode = this.getSourceAssetCode();
        String other$sourceAssetCode = other.getSourceAssetCode();
        if (this$sourceAssetCode == null ? other$sourceAssetCode != null : !this$sourceAssetCode.equals(other$sourceAssetCode)) {
            return false;
        }
        String this$sourceAssetIssuer = this.getSourceAssetIssuer();
        String other$sourceAssetIssuer = other.getSourceAssetIssuer();
        if (this$sourceAssetIssuer == null ? other$sourceAssetIssuer != null : !this$sourceAssetIssuer.equals(other$sourceAssetIssuer)) {
            return false;
        }
        List<Asset> this$path = this.getPath();
        List<Asset> other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentBaseOperationResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $sourceAmount = this.getSourceAmount();
        result = result * 59 + ($sourceAmount == null ? 43 : $sourceAmount.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Optional<MuxedAccount> $fromMuxed = this.getFromMuxed();
        result = result * 59 + ($fromMuxed == null ? 43 : ((Object)$fromMuxed).hashCode());
        BigInteger $fromMuxedId = this.getFromMuxedId();
        result = result * 59 + ($fromMuxedId == null ? 43 : ((Object)$fromMuxedId).hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Optional<MuxedAccount> $toMuxed = this.getToMuxed();
        result = result * 59 + ($toMuxed == null ? 43 : ((Object)$toMuxed).hashCode());
        BigInteger $toMuxedId = this.getToMuxedId();
        result = result * 59 + ($toMuxedId == null ? 43 : ((Object)$toMuxedId).hashCode());
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        String $assetIssuer = this.getAssetIssuer();
        result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
        String $sourceAssetType = this.getSourceAssetType();
        result = result * 59 + ($sourceAssetType == null ? 43 : $sourceAssetType.hashCode());
        String $sourceAssetCode = this.getSourceAssetCode();
        result = result * 59 + ($sourceAssetCode == null ? 43 : $sourceAssetCode.hashCode());
        String $sourceAssetIssuer = this.getSourceAssetIssuer();
        result = result * 59 + ($sourceAssetIssuer == null ? 43 : $sourceAssetIssuer.hashCode());
        List<Asset> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }
}

