/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ChangeTrustResultCode implements XdrElement
{
    CHANGE_TRUST_SUCCESS(0),
    CHANGE_TRUST_MALFORMED(-1),
    CHANGE_TRUST_NO_ISSUER(-2),
    CHANGE_TRUST_INVALID_LIMIT(-3),
    CHANGE_TRUST_LOW_RESERVE(-4),
    CHANGE_TRUST_SELF_NOT_ALLOWED(-5),
    CHANGE_TRUST_TRUST_LINE_MISSING(-6),
    CHANGE_TRUST_CANNOT_DELETE(-7),
    CHANGE_TRUST_NOT_AUTH_MAINTAIN_LIABILITIES(-8);

    private int mValue;

    private ChangeTrustResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static ChangeTrustResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CHANGE_TRUST_SUCCESS;
            }
            case -1: {
                return CHANGE_TRUST_MALFORMED;
            }
            case -2: {
                return CHANGE_TRUST_NO_ISSUER;
            }
            case -3: {
                return CHANGE_TRUST_INVALID_LIMIT;
            }
            case -4: {
                return CHANGE_TRUST_LOW_RESERVE;
            }
            case -5: {
                return CHANGE_TRUST_SELF_NOT_ALLOWED;
            }
            case -6: {
                return CHANGE_TRUST_TRUST_LINE_MISSING;
            }
            case -7: {
                return CHANGE_TRUST_CANNOT_DELETE;
            }
            case -8: {
                return CHANGE_TRUST_NOT_AUTH_MAINTAIN_LIABILITIES;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, ChangeTrustResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ChangeTrustResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ChangeTrustResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ChangeTrustResultCode.fromXdrByteArray(bytes);
    }

    public static ChangeTrustResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ChangeTrustResultCode.decode(xdrDataInputStream);
    }
}

