/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimOfferAtomV0
implements XdrElement {
    private Uint256 sellerEd25519;
    private Int64 offerID;
    private Asset assetSold;
    private Int64 amountSold;
    private Asset assetBought;
    private Int64 amountBought;

    public Uint256 getSellerEd25519() {
        return this.sellerEd25519;
    }

    public void setSellerEd25519(Uint256 value) {
        this.sellerEd25519 = value;
    }

    public Int64 getOfferID() {
        return this.offerID;
    }

    public void setOfferID(Int64 value) {
        this.offerID = value;
    }

    public Asset getAssetSold() {
        return this.assetSold;
    }

    public void setAssetSold(Asset value) {
        this.assetSold = value;
    }

    public Int64 getAmountSold() {
        return this.amountSold;
    }

    public void setAmountSold(Int64 value) {
        this.amountSold = value;
    }

    public Asset getAssetBought() {
        return this.assetBought;
    }

    public void setAssetBought(Asset value) {
        this.assetBought = value;
    }

    public Int64 getAmountBought() {
        return this.amountBought;
    }

    public void setAmountBought(Int64 value) {
        this.amountBought = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimOfferAtomV0 encodedClaimOfferAtomV0) throws IOException {
        Uint256.encode(stream, encodedClaimOfferAtomV0.sellerEd25519);
        Int64.encode(stream, encodedClaimOfferAtomV0.offerID);
        Asset.encode(stream, encodedClaimOfferAtomV0.assetSold);
        Int64.encode(stream, encodedClaimOfferAtomV0.amountSold);
        Asset.encode(stream, encodedClaimOfferAtomV0.assetBought);
        Int64.encode(stream, encodedClaimOfferAtomV0.amountBought);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimOfferAtomV0.encode(stream, this);
    }

    public static ClaimOfferAtomV0 decode(XdrDataInputStream stream) throws IOException {
        ClaimOfferAtomV0 decodedClaimOfferAtomV0 = new ClaimOfferAtomV0();
        decodedClaimOfferAtomV0.sellerEd25519 = Uint256.decode(stream);
        decodedClaimOfferAtomV0.offerID = Int64.decode(stream);
        decodedClaimOfferAtomV0.assetSold = Asset.decode(stream);
        decodedClaimOfferAtomV0.amountSold = Int64.decode(stream);
        decodedClaimOfferAtomV0.assetBought = Asset.decode(stream);
        decodedClaimOfferAtomV0.amountBought = Int64.decode(stream);
        return decodedClaimOfferAtomV0;
    }

    public int hashCode() {
        return Objects.hash(this.sellerEd25519, this.offerID, this.assetSold, this.amountSold, this.assetBought, this.amountBought);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimOfferAtomV0)) {
            return false;
        }
        ClaimOfferAtomV0 other = (ClaimOfferAtomV0)object;
        return Objects.equals(this.sellerEd25519, other.sellerEd25519) && Objects.equals(this.offerID, other.offerID) && Objects.equals(this.assetSold, other.assetSold) && Objects.equals(this.amountSold, other.amountSold) && Objects.equals(this.assetBought, other.assetBought) && Objects.equals(this.amountBought, other.amountBought);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ClaimOfferAtomV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimOfferAtomV0.fromXdrByteArray(bytes);
    }

    public static ClaimOfferAtomV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimOfferAtomV0.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Uint256 sellerEd25519;
        private Int64 offerID;
        private Asset assetSold;
        private Int64 amountSold;
        private Asset assetBought;
        private Int64 amountBought;

        public Builder sellerEd25519(Uint256 sellerEd25519) {
            this.sellerEd25519 = sellerEd25519;
            return this;
        }

        public Builder offerID(Int64 offerID) {
            this.offerID = offerID;
            return this;
        }

        public Builder assetSold(Asset assetSold) {
            this.assetSold = assetSold;
            return this;
        }

        public Builder amountSold(Int64 amountSold) {
            this.amountSold = amountSold;
            return this;
        }

        public Builder assetBought(Asset assetBought) {
            this.assetBought = assetBought;
            return this;
        }

        public Builder amountBought(Int64 amountBought) {
            this.amountBought = amountBought;
            return this;
        }

        public ClaimOfferAtomV0 build() {
            ClaimOfferAtomV0 val = new ClaimOfferAtomV0();
            val.setSellerEd25519(this.sellerEd25519);
            val.setOfferID(this.offerID);
            val.setAssetSold(this.assetSold);
            val.setAmountSold(this.amountSold);
            val.setAssetBought(this.assetBought);
            val.setAmountBought(this.amountBought);
            return val;
        }
    }
}

