/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimPredicate;
import org.stellar.sdk.xdr.ClaimantType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Claimant
implements XdrElement {
    ClaimantType type;
    private ClaimantV0 v0;

    public ClaimantType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ClaimantType value) {
        this.type = value;
    }

    public ClaimantV0 getV0() {
        return this.v0;
    }

    public void setV0(ClaimantV0 value) {
        this.v0 = value;
    }

    public static void encode(XdrDataOutputStream stream, Claimant encodedClaimant) throws IOException {
        stream.writeInt(encodedClaimant.getDiscriminant().getValue());
        switch (encodedClaimant.getDiscriminant()) {
            case CLAIMANT_TYPE_V0: {
                ClaimantV0.encode(stream, encodedClaimant.v0);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Claimant.encode(stream, this);
    }

    public static Claimant decode(XdrDataInputStream stream) throws IOException {
        Claimant decodedClaimant = new Claimant();
        ClaimantType discriminant = ClaimantType.decode(stream);
        decodedClaimant.setDiscriminant(discriminant);
        switch (decodedClaimant.getDiscriminant()) {
            case CLAIMANT_TYPE_V0: {
                decodedClaimant.v0 = ClaimantV0.decode(stream);
            }
        }
        return decodedClaimant;
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Claimant)) {
            return false;
        }
        Claimant other = (Claimant)object;
        return Objects.equals(this.v0, other.v0) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Claimant fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Claimant.fromXdrByteArray(bytes);
    }

    public static Claimant fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Claimant.decode(xdrDataInputStream);
    }

    public static class ClaimantV0
    implements XdrElement {
        private AccountID destination;
        private ClaimPredicate predicate;

        public AccountID getDestination() {
            return this.destination;
        }

        public void setDestination(AccountID value) {
            this.destination = value;
        }

        public ClaimPredicate getPredicate() {
            return this.predicate;
        }

        public void setPredicate(ClaimPredicate value) {
            this.predicate = value;
        }

        public static void encode(XdrDataOutputStream stream, ClaimantV0 encodedClaimantV0) throws IOException {
            AccountID.encode(stream, encodedClaimantV0.destination);
            ClaimPredicate.encode(stream, encodedClaimantV0.predicate);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            ClaimantV0.encode(stream, this);
        }

        public static ClaimantV0 decode(XdrDataInputStream stream) throws IOException {
            ClaimantV0 decodedClaimantV0 = new ClaimantV0();
            decodedClaimantV0.destination = AccountID.decode(stream);
            decodedClaimantV0.predicate = ClaimPredicate.decode(stream);
            return decodedClaimantV0;
        }

        public int hashCode() {
            return Objects.hash(this.destination, this.predicate);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClaimantV0)) {
                return false;
            }
            ClaimantV0 other = (ClaimantV0)object;
            return Objects.equals(this.destination, other.destination) && Objects.equals(this.predicate, other.predicate);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static ClaimantV0 fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ClaimantV0.fromXdrByteArray(bytes);
        }

        public static ClaimantV0 fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ClaimantV0.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID destination;
            private ClaimPredicate predicate;

            public Builder destination(AccountID destination) {
                this.destination = destination;
                return this;
            }

            public Builder predicate(ClaimPredicate predicate) {
                this.predicate = predicate;
                return this;
            }

            public ClaimantV0 build() {
                ClaimantV0 val = new ClaimantV0();
                val.setDestination(this.destination);
                val.setPredicate(this.predicate);
                return val;
            }
        }
    }

    public static final class Builder {
        private ClaimantType discriminant;
        private ClaimantV0 v0;

        public Builder discriminant(ClaimantType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(ClaimantV0 v0) {
            this.v0 = v0;
            return this;
        }

        public Claimant build() {
            Claimant val = new Claimant();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            return val;
        }
    }
}

