/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ErrorCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class Error
implements XdrElement {
    private ErrorCode code;
    private XdrString msg;

    public ErrorCode getCode() {
        return this.code;
    }

    public void setCode(ErrorCode value) {
        this.code = value;
    }

    public XdrString getMsg() {
        return this.msg;
    }

    public void setMsg(XdrString value) {
        this.msg = value;
    }

    public static void encode(XdrDataOutputStream stream, Error encodedError) throws IOException {
        ErrorCode.encode(stream, encodedError.code);
        encodedError.msg.encode(stream);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Error.encode(stream, this);
    }

    public static Error decode(XdrDataInputStream stream) throws IOException {
        Error decodedError = new Error();
        decodedError.code = ErrorCode.decode(stream);
        decodedError.msg = XdrString.decode(stream, 100);
        return decodedError;
    }

    public int hashCode() {
        return Objects.hash(this.code, this.msg);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Error)) {
            return false;
        }
        Error other = (Error)object;
        return Objects.equals(this.code, other.code) && Objects.equals(this.msg, other.msg);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Error fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Error.fromXdrByteArray(bytes);
    }

    public static Error fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Error.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ErrorCode code;
        private XdrString msg;

        public Builder code(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder msg(XdrString msg) {
            this.msg = msg;
            return this;
        }

        public Error build() {
            Error val = new Error();
            val.setCode(this.code);
            val.setMsg(this.msg);
            return val;
        }
    }
}

