/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HmacSha256Key
implements XdrElement {
    private byte[] key;

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] value) {
        this.key = value;
    }

    public static void encode(XdrDataOutputStream stream, HmacSha256Key encodedHmacSha256Key) throws IOException {
        int keysize = encodedHmacSha256Key.key.length;
        stream.write(encodedHmacSha256Key.getKey(), 0, keysize);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        HmacSha256Key.encode(stream, this);
    }

    public static HmacSha256Key decode(XdrDataInputStream stream) throws IOException {
        HmacSha256Key decodedHmacSha256Key = new HmacSha256Key();
        int keysize = 32;
        decodedHmacSha256Key.key = new byte[keysize];
        stream.read(decodedHmacSha256Key.key, 0, keysize);
        return decodedHmacSha256Key;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HmacSha256Key)) {
            return false;
        }
        HmacSha256Key other = (HmacSha256Key)object;
        return Arrays.equals(this.key, other.key);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static HmacSha256Key fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HmacSha256Key.fromXdrByteArray(bytes);
    }

    public static HmacSha256Key fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HmacSha256Key.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private byte[] key;

        public Builder key(byte[] key) {
            this.key = key;
            return this;
        }

        public HmacSha256Key build() {
            HmacSha256Key val = new HmacSha256Key();
            val.setKey(this.key);
            return val;
        }
    }
}

