/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PreconditionType;
import org.stellar.sdk.xdr.PreconditionsV2;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Preconditions
implements XdrElement {
    PreconditionType type;
    private TimeBounds timeBounds;
    private PreconditionsV2 v2;

    public PreconditionType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(PreconditionType value) {
        this.type = value;
    }

    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    public void setTimeBounds(TimeBounds value) {
        this.timeBounds = value;
    }

    public PreconditionsV2 getV2() {
        return this.v2;
    }

    public void setV2(PreconditionsV2 value) {
        this.v2 = value;
    }

    public static void encode(XdrDataOutputStream stream, Preconditions encodedPreconditions) throws IOException {
        stream.writeInt(encodedPreconditions.getDiscriminant().getValue());
        switch (encodedPreconditions.getDiscriminant()) {
            case PRECOND_NONE: {
                break;
            }
            case PRECOND_TIME: {
                TimeBounds.encode(stream, encodedPreconditions.timeBounds);
                break;
            }
            case PRECOND_V2: {
                PreconditionsV2.encode(stream, encodedPreconditions.v2);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Preconditions.encode(stream, this);
    }

    public static Preconditions decode(XdrDataInputStream stream) throws IOException {
        Preconditions decodedPreconditions = new Preconditions();
        PreconditionType discriminant = PreconditionType.decode(stream);
        decodedPreconditions.setDiscriminant(discriminant);
        switch (decodedPreconditions.getDiscriminant()) {
            case PRECOND_NONE: {
                break;
            }
            case PRECOND_TIME: {
                decodedPreconditions.timeBounds = TimeBounds.decode(stream);
                break;
            }
            case PRECOND_V2: {
                decodedPreconditions.v2 = PreconditionsV2.decode(stream);
            }
        }
        return decodedPreconditions;
    }

    public int hashCode() {
        return Objects.hash(this.timeBounds, this.v2, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Preconditions)) {
            return false;
        }
        Preconditions other = (Preconditions)object;
        return Objects.equals(this.timeBounds, other.timeBounds) && Objects.equals(this.v2, other.v2) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Preconditions fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Preconditions.fromXdrByteArray(bytes);
    }

    public static Preconditions fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Preconditions.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private PreconditionType discriminant;
        private TimeBounds timeBounds;
        private PreconditionsV2 v2;

        public Builder discriminant(PreconditionType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        public Builder v2(PreconditionsV2 v2) {
            this.v2 = v2;
            return this;
        }

        public Preconditions build() {
            Preconditions val = new Preconditions();
            val.setDiscriminant(this.discriminant);
            val.setTimeBounds(this.timeBounds);
            val.setV2(this.v2);
            return val;
        }
    }
}

