/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCNonceKey
implements XdrElement {
    private Int64 nonce;

    public Int64 getNonce() {
        return this.nonce;
    }

    public void setNonce(Int64 value) {
        this.nonce = value;
    }

    public static void encode(XdrDataOutputStream stream, SCNonceKey encodedSCNonceKey) throws IOException {
        Int64.encode(stream, encodedSCNonceKey.nonce);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCNonceKey.encode(stream, this);
    }

    public static SCNonceKey decode(XdrDataInputStream stream) throws IOException {
        SCNonceKey decodedSCNonceKey = new SCNonceKey();
        decodedSCNonceKey.nonce = Int64.decode(stream);
        return decodedSCNonceKey;
    }

    public int hashCode() {
        return Objects.hash(this.nonce);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCNonceKey)) {
            return false;
        }
        SCNonceKey other = (SCNonceKey)object;
        return Objects.equals(this.nonce, other.nonce);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCNonceKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCNonceKey.fromXdrByteArray(bytes);
    }

    public static SCNonceKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCNonceKey.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Int64 nonce;

        public Builder nonce(Int64 nonce) {
            this.nonce = nonce;
            return this;
        }

        public SCNonceKey build() {
            SCNonceKey val = new SCNonceKey();
            val.setNonce(this.nonce);
            return val;
        }
    }
}

