/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPQuorumSet
implements XdrElement {
    private Uint32 threshold;
    private NodeID[] validators;
    private SCPQuorumSet[] innerSets;

    public Uint32 getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Uint32 value) {
        this.threshold = value;
    }

    public NodeID[] getValidators() {
        return this.validators;
    }

    public void setValidators(NodeID[] value) {
        this.validators = value;
    }

    public SCPQuorumSet[] getInnerSets() {
        return this.innerSets;
    }

    public void setInnerSets(SCPQuorumSet[] value) {
        this.innerSets = value;
    }

    public static void encode(XdrDataOutputStream stream, SCPQuorumSet encodedSCPQuorumSet) throws IOException {
        Uint32.encode(stream, encodedSCPQuorumSet.threshold);
        int validatorssize = encodedSCPQuorumSet.getValidators().length;
        stream.writeInt(validatorssize);
        for (int i = 0; i < validatorssize; ++i) {
            NodeID.encode(stream, encodedSCPQuorumSet.validators[i]);
        }
        int innerSetssize = encodedSCPQuorumSet.getInnerSets().length;
        stream.writeInt(innerSetssize);
        for (int i = 0; i < innerSetssize; ++i) {
            SCPQuorumSet.encode(stream, encodedSCPQuorumSet.innerSets[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCPQuorumSet.encode(stream, this);
    }

    public static SCPQuorumSet decode(XdrDataInputStream stream) throws IOException {
        SCPQuorumSet decodedSCPQuorumSet = new SCPQuorumSet();
        decodedSCPQuorumSet.threshold = Uint32.decode(stream);
        int validatorssize = stream.readInt();
        decodedSCPQuorumSet.validators = new NodeID[validatorssize];
        for (int i = 0; i < validatorssize; ++i) {
            decodedSCPQuorumSet.validators[i] = NodeID.decode(stream);
        }
        int innerSetssize = stream.readInt();
        decodedSCPQuorumSet.innerSets = new SCPQuorumSet[innerSetssize];
        for (int i = 0; i < innerSetssize; ++i) {
            decodedSCPQuorumSet.innerSets[i] = SCPQuorumSet.decode(stream);
        }
        return decodedSCPQuorumSet;
    }

    public int hashCode() {
        return Objects.hash(this.threshold, Arrays.hashCode(this.validators), Arrays.hashCode(this.innerSets));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCPQuorumSet)) {
            return false;
        }
        SCPQuorumSet other = (SCPQuorumSet)object;
        return Objects.equals(this.threshold, other.threshold) && Arrays.equals(this.validators, other.validators) && Arrays.equals(this.innerSets, other.innerSets);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCPQuorumSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPQuorumSet.fromXdrByteArray(bytes);
    }

    public static SCPQuorumSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPQuorumSet.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Uint32 threshold;
        private NodeID[] validators;
        private SCPQuorumSet[] innerSets;

        public Builder threshold(Uint32 threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder validators(NodeID[] validators) {
            this.validators = validators;
            return this;
        }

        public Builder innerSets(SCPQuorumSet[] innerSets) {
            this.innerSets = innerSets;
            return this;
        }

        public SCPQuorumSet build() {
            SCPQuorumSet val = new SCPQuorumSet();
            val.setThreshold(this.threshold);
            val.setValidators(this.validators);
            val.setInnerSets(this.innerSets);
            return val;
        }
    }
}

