/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SurveyMessageResponseType;
import org.stellar.sdk.xdr.TopologyResponseBodyV0;
import org.stellar.sdk.xdr.TopologyResponseBodyV1;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SurveyResponseBody
implements XdrElement {
    SurveyMessageResponseType type;
    private TopologyResponseBodyV0 topologyResponseBodyV0;
    private TopologyResponseBodyV1 topologyResponseBodyV1;

    public SurveyMessageResponseType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(SurveyMessageResponseType value) {
        this.type = value;
    }

    public TopologyResponseBodyV0 getTopologyResponseBodyV0() {
        return this.topologyResponseBodyV0;
    }

    public void setTopologyResponseBodyV0(TopologyResponseBodyV0 value) {
        this.topologyResponseBodyV0 = value;
    }

    public TopologyResponseBodyV1 getTopologyResponseBodyV1() {
        return this.topologyResponseBodyV1;
    }

    public void setTopologyResponseBodyV1(TopologyResponseBodyV1 value) {
        this.topologyResponseBodyV1 = value;
    }

    public static void encode(XdrDataOutputStream stream, SurveyResponseBody encodedSurveyResponseBody) throws IOException {
        stream.writeInt(encodedSurveyResponseBody.getDiscriminant().getValue());
        switch (encodedSurveyResponseBody.getDiscriminant()) {
            case SURVEY_TOPOLOGY_RESPONSE_V0: {
                TopologyResponseBodyV0.encode(stream, encodedSurveyResponseBody.topologyResponseBodyV0);
                break;
            }
            case SURVEY_TOPOLOGY_RESPONSE_V1: {
                TopologyResponseBodyV1.encode(stream, encodedSurveyResponseBody.topologyResponseBodyV1);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SurveyResponseBody.encode(stream, this);
    }

    public static SurveyResponseBody decode(XdrDataInputStream stream) throws IOException {
        SurveyResponseBody decodedSurveyResponseBody = new SurveyResponseBody();
        SurveyMessageResponseType discriminant = SurveyMessageResponseType.decode(stream);
        decodedSurveyResponseBody.setDiscriminant(discriminant);
        switch (decodedSurveyResponseBody.getDiscriminant()) {
            case SURVEY_TOPOLOGY_RESPONSE_V0: {
                decodedSurveyResponseBody.topologyResponseBodyV0 = TopologyResponseBodyV0.decode(stream);
                break;
            }
            case SURVEY_TOPOLOGY_RESPONSE_V1: {
                decodedSurveyResponseBody.topologyResponseBodyV1 = TopologyResponseBodyV1.decode(stream);
            }
        }
        return decodedSurveyResponseBody;
    }

    public int hashCode() {
        return Objects.hash(this.topologyResponseBodyV0, this.topologyResponseBodyV1, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SurveyResponseBody)) {
            return false;
        }
        SurveyResponseBody other = (SurveyResponseBody)object;
        return Objects.equals(this.topologyResponseBodyV0, other.topologyResponseBodyV0) && Objects.equals(this.topologyResponseBodyV1, other.topologyResponseBodyV1) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SurveyResponseBody fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SurveyResponseBody.fromXdrByteArray(bytes);
    }

    public static SurveyResponseBody fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SurveyResponseBody.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SurveyMessageResponseType discriminant;
        private TopologyResponseBodyV0 topologyResponseBodyV0;
        private TopologyResponseBodyV1 topologyResponseBodyV1;

        public Builder discriminant(SurveyMessageResponseType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder topologyResponseBodyV0(TopologyResponseBodyV0 topologyResponseBodyV0) {
            this.topologyResponseBodyV0 = topologyResponseBodyV0;
            return this;
        }

        public Builder topologyResponseBodyV1(TopologyResponseBodyV1 topologyResponseBodyV1) {
            this.topologyResponseBodyV1 = topologyResponseBodyV1;
            return this;
        }

        public SurveyResponseBody build() {
            SurveyResponseBody val = new SurveyResponseBody();
            val.setDiscriminant(this.discriminant);
            val.setTopologyResponseBodyV0(this.topologyResponseBodyV0);
            val.setTopologyResponseBodyV1(this.topologyResponseBodyV1);
            return val;
        }
    }
}

