/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class Uint64
implements XdrElement {
    private XdrUnsignedHyperInteger uint64;

    public Uint64() {
    }

    public Uint64(XdrUnsignedHyperInteger uint64) {
        this.uint64 = uint64;
    }

    public XdrUnsignedHyperInteger getUint64() {
        return this.uint64;
    }

    public void setUint64(XdrUnsignedHyperInteger value) {
        this.uint64 = value;
    }

    public static void encode(XdrDataOutputStream stream, Uint64 encodedUint64) throws IOException {
        encodedUint64.uint64.encode(stream);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Uint64.encode(stream, this);
    }

    public static Uint64 decode(XdrDataInputStream stream) throws IOException {
        Uint64 decodedUint64 = new Uint64();
        decodedUint64.uint64 = XdrUnsignedHyperInteger.decode(stream);
        return decodedUint64;
    }

    public int hashCode() {
        return Objects.hash(this.uint64);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Uint64)) {
            return false;
        }
        Uint64 other = (Uint64)object;
        return Objects.equals(this.uint64, other.uint64);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Uint64 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Uint64.fromXdrByteArray(bytes);
    }

    public static Uint64 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Uint64.decode(xdrDataInputStream);
    }
}

