/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ClawbackClaimableBalanceOperation
extends Operation {
    @NonNull
    private final String balanceId;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ClaimableBalanceID balanceId;
        byte[] balanceIdBytes = Util.hexToBytes(this.balanceId);
        try {
            balanceId = ClaimableBalanceID.fromXdrByteArray(balanceIdBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid balanceId: " + this.balanceId, e);
        }
        ClawbackClaimableBalanceOp op = new ClawbackClaimableBalanceOp();
        op.setBalanceID(balanceId);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAWBACK_CLAIMABLE_BALANCE);
        body.setClawbackClaimableBalanceOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClawbackClaimableBalanceOperation)) {
            return false;
        }
        ClawbackClaimableBalanceOperation other = (ClawbackClaimableBalanceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$balanceId = this.getBalanceId();
        String other$balanceId = other.getBalanceId();
        return !(this$balanceId == null ? other$balanceId != null : !this$balanceId.equals(other$balanceId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClawbackClaimableBalanceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $balanceId = this.getBalanceId();
        result = result * 59 + ($balanceId == null ? 43 : $balanceId.hashCode());
        return result;
    }

    @Generated
    private ClawbackClaimableBalanceOperation(@NonNull String balanceId) {
        if (balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
        this.balanceId = balanceId;
    }

    public static class Builder {
        private final String balanceId;
        private String sourceAccount;

        Builder(ClawbackClaimableBalanceOp op) {
            try {
                this.balanceId = Util.bytesToHex(op.getBalanceID().toXdrByteArray()).toLowerCase();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid balanceId in the operation", e);
            }
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public ClawbackClaimableBalanceOperation build() {
            ClawbackClaimableBalanceOperation operation = new ClawbackClaimableBalanceOperation(this.balanceId);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

