/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClawbackOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ClawbackOperation
extends Operation {
    @NonNull
    private final String from;
    @NonNull
    private final AssetTypeCreditAlphaNum asset;
    @NonNull
    private final String amount;

    public Asset getAsset() {
        return this.asset;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ClawbackOp op = new ClawbackOp();
        op.setFrom(accountConverter.encode(this.from));
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        op.setAsset(this.asset.toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAWBACK);
        body.setClawbackOp(op);
        return body;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClawbackOperation)) {
            return false;
        }
        ClawbackOperation other = (ClawbackOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !this$amount.equals(other$amount));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClawbackOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        return result;
    }

    @Generated
    private ClawbackOperation(@NonNull String from, @NonNull AssetTypeCreditAlphaNum asset, @NonNull String amount) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.from = from;
        this.asset = asset;
        this.amount = amount;
    }

    @NonNull
    @Generated
    public String getFrom() {
        return this.from;
    }

    @NonNull
    @Generated
    public String getAmount() {
        return this.amount;
    }

    public static class Builder {
        private final String from;
        private final AssetTypeCreditAlphaNum asset;
        private final String amount;
        private String sourceAccount;

        Builder(AccountConverter accountConverter, ClawbackOp op) {
            this.from = accountConverter.decode(op.getFrom());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.asset = Util.assertNonNativeAsset(Asset.fromXdr(op.getAsset()));
        }

        public Builder(String from, Asset asset, String amount) {
            this.from = from;
            this.asset = Util.assertNonNativeAsset(asset);
            this.amount = amount;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public ClawbackOperation build() {
            ClawbackOperation operation = new ClawbackOperation(this.from, this.asset, this.amount);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

