/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.FormatException;
import org.stellar.sdk.LedgerBounds;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerBounds;
import org.stellar.sdk.xdr.PreconditionType;
import org.stellar.sdk.xdr.Preconditions;
import org.stellar.sdk.xdr.PreconditionsV2;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public final class TransactionPreconditions {
    public static final long MAX_EXTRA_SIGNERS_COUNT = 2L;
    public static final BigInteger TIMEOUT_INFINITE = BigInteger.ZERO;
    private final LedgerBounds ledgerBounds;
    private final Long minSeqNumber;
    private final BigInteger minSeqAge;
    private final long minSeqLedgerGap;
    @NonNull
    private final List<SignerKey> extraSigners;
    private final TimeBounds timeBounds;

    public void isValid() {
        if (this.timeBounds == null) {
            throw new FormatException("Invalid preconditions, must define timebounds");
        }
        if ((long)this.extraSigners.size() > 2L) {
            throw new FormatException("Invalid preconditions, too many extra signers, can only have up to 2");
        }
    }

    public boolean hasV2() {
        return this.ledgerBounds != null || this.minSeqLedgerGap > 0L || this.minSeqAge.compareTo(BigInteger.ZERO) > 0 || this.minSeqNumber != null || !this.extraSigners.isEmpty();
    }

    public static TransactionPreconditions fromXdr(Preconditions preconditions) {
        TransactionPreconditionsBuilder builder = new TransactionPreconditionsBuilder();
        if (preconditions.getDiscriminant().equals(PreconditionType.PRECOND_V2)) {
            if (preconditions.getV2().getTimeBounds() != null) {
                builder.timeBounds(new TimeBounds(preconditions.getV2().getTimeBounds().getMinTime().getTimePoint().getUint64().getNumber(), preconditions.getV2().getTimeBounds().getMaxTime().getTimePoint().getUint64().getNumber()));
            }
            if (preconditions.getV2().getExtraSigners() != null && preconditions.getV2().getExtraSigners().length > 0) {
                builder.extraSigners(Arrays.asList(preconditions.getV2().getExtraSigners()));
            }
            if (preconditions.getV2().getMinSeqAge() != null) {
                builder.minSeqAge(preconditions.getV2().getMinSeqAge().getDuration().getUint64().getNumber());
            }
            if (preconditions.getV2().getLedgerBounds() != null) {
                builder.ledgerBounds(LedgerBounds.fromXdr(preconditions.getV2().getLedgerBounds()));
            }
            if (preconditions.getV2().getMinSeqNum() != null) {
                builder.minSeqNumber(preconditions.getV2().getMinSeqNum().getSequenceNumber().getInt64());
            }
            if (preconditions.getV2().getMinSeqLedgerGap() != null) {
                builder.minSeqLedgerGap(preconditions.getV2().getMinSeqLedgerGap().getUint32().getNumber().intValue());
            }
        } else if (preconditions.getTimeBounds() != null) {
            builder.timeBounds(new TimeBounds(preconditions.getTimeBounds().getMinTime().getTimePoint().getUint64().getNumber(), preconditions.getTimeBounds().getMaxTime().getTimePoint().getUint64().getNumber()));
        }
        return builder.build();
    }

    public Preconditions toXdr() {
        Preconditions.Builder preconditionsBuilder = new Preconditions.Builder();
        if (this.hasV2()) {
            preconditionsBuilder.discriminant(PreconditionType.PRECOND_V2);
            PreconditionsV2.Builder v2Builder = new PreconditionsV2.Builder();
            v2Builder.extraSigners(this.extraSigners.toArray(new SignerKey[0]));
            v2Builder.minSeqAge(new Duration(new Uint64(new XdrUnsignedHyperInteger(this.minSeqAge))));
            if (this.ledgerBounds != null) {
                v2Builder.ledgerBounds(new LedgerBounds.Builder().minLedger(new Uint32(new XdrUnsignedInteger(this.ledgerBounds.getMinLedger()))).maxLedger(new Uint32(new XdrUnsignedInteger(this.ledgerBounds.getMaxLedger()))).build());
            }
            if (this.minSeqNumber != null) {
                v2Builder.minSeqNum(new SequenceNumber(new Int64(this.minSeqNumber)));
            }
            v2Builder.minSeqLedgerGap(new Uint32(new XdrUnsignedInteger(this.minSeqLedgerGap)));
            if (this.timeBounds != null) {
                v2Builder.timeBounds(this.timeBounds.toXdr());
            }
            preconditionsBuilder.v2(v2Builder.build());
        } else if (this.timeBounds == null) {
            preconditionsBuilder.discriminant(PreconditionType.PRECOND_NONE);
        } else {
            preconditionsBuilder.discriminant(PreconditionType.PRECOND_TIME);
            preconditionsBuilder.timeBounds(this.timeBounds.toXdr());
        }
        return preconditionsBuilder.build();
    }

    @Generated
    private static BigInteger $default$minSeqAge() {
        return BigInteger.ZERO;
    }

    @Generated
    TransactionPreconditions(LedgerBounds ledgerBounds, Long minSeqNumber, BigInteger minSeqAge, long minSeqLedgerGap, @NonNull List<SignerKey> extraSigners, TimeBounds timeBounds) {
        if (extraSigners == null) {
            throw new NullPointerException("extraSigners is marked non-null but is null");
        }
        this.ledgerBounds = ledgerBounds;
        this.minSeqNumber = minSeqNumber;
        this.minSeqAge = minSeqAge;
        this.minSeqLedgerGap = minSeqLedgerGap;
        this.extraSigners = extraSigners;
        this.timeBounds = timeBounds;
    }

    @Generated
    public static TransactionPreconditionsBuilder builder() {
        return new TransactionPreconditionsBuilder();
    }

    @Generated
    public TransactionPreconditionsBuilder toBuilder() {
        TransactionPreconditionsBuilder builder = new TransactionPreconditionsBuilder().ledgerBounds(this.ledgerBounds).minSeqNumber(this.minSeqNumber).minSeqAge(this.minSeqAge).minSeqLedgerGap(this.minSeqLedgerGap).timeBounds(this.timeBounds);
        if (this.extraSigners != null) {
            builder.extraSigners(this.extraSigners);
        }
        return builder;
    }

    @Generated
    public LedgerBounds getLedgerBounds() {
        return this.ledgerBounds;
    }

    @Generated
    public Long getMinSeqNumber() {
        return this.minSeqNumber;
    }

    @Generated
    public BigInteger getMinSeqAge() {
        return this.minSeqAge;
    }

    @Generated
    public long getMinSeqLedgerGap() {
        return this.minSeqLedgerGap;
    }

    @NonNull
    @Generated
    public List<SignerKey> getExtraSigners() {
        return this.extraSigners;
    }

    @Generated
    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionPreconditions)) {
            return false;
        }
        TransactionPreconditions other = (TransactionPreconditions)o;
        if (this.getMinSeqLedgerGap() != other.getMinSeqLedgerGap()) {
            return false;
        }
        Long this$minSeqNumber = this.getMinSeqNumber();
        Long other$minSeqNumber = other.getMinSeqNumber();
        if (this$minSeqNumber == null ? other$minSeqNumber != null : !((Object)this$minSeqNumber).equals(other$minSeqNumber)) {
            return false;
        }
        LedgerBounds this$ledgerBounds = this.getLedgerBounds();
        LedgerBounds other$ledgerBounds = other.getLedgerBounds();
        if (this$ledgerBounds == null ? other$ledgerBounds != null : !((Object)this$ledgerBounds).equals(other$ledgerBounds)) {
            return false;
        }
        BigInteger this$minSeqAge = this.getMinSeqAge();
        BigInteger other$minSeqAge = other.getMinSeqAge();
        if (this$minSeqAge == null ? other$minSeqAge != null : !((Object)this$minSeqAge).equals(other$minSeqAge)) {
            return false;
        }
        List<SignerKey> this$extraSigners = this.getExtraSigners();
        List<SignerKey> other$extraSigners = other.getExtraSigners();
        if (this$extraSigners == null ? other$extraSigners != null : !((Object)this$extraSigners).equals(other$extraSigners)) {
            return false;
        }
        TimeBounds this$timeBounds = this.getTimeBounds();
        TimeBounds other$timeBounds = other.getTimeBounds();
        return !(this$timeBounds == null ? other$timeBounds != null : !((Object)this$timeBounds).equals(other$timeBounds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minSeqLedgerGap = this.getMinSeqLedgerGap();
        result = result * 59 + (int)($minSeqLedgerGap >>> 32 ^ $minSeqLedgerGap);
        Long $minSeqNumber = this.getMinSeqNumber();
        result = result * 59 + ($minSeqNumber == null ? 43 : ((Object)$minSeqNumber).hashCode());
        LedgerBounds $ledgerBounds = this.getLedgerBounds();
        result = result * 59 + ($ledgerBounds == null ? 43 : ((Object)$ledgerBounds).hashCode());
        BigInteger $minSeqAge = this.getMinSeqAge();
        result = result * 59 + ($minSeqAge == null ? 43 : ((Object)$minSeqAge).hashCode());
        List<SignerKey> $extraSigners = this.getExtraSigners();
        result = result * 59 + ($extraSigners == null ? 43 : ((Object)$extraSigners).hashCode());
        TimeBounds $timeBounds = this.getTimeBounds();
        result = result * 59 + ($timeBounds == null ? 43 : ((Object)$timeBounds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionPreconditions(ledgerBounds=" + this.getLedgerBounds() + ", minSeqNumber=" + this.getMinSeqNumber() + ", minSeqAge=" + this.getMinSeqAge() + ", minSeqLedgerGap=" + this.getMinSeqLedgerGap() + ", extraSigners=" + this.getExtraSigners() + ", timeBounds=" + this.getTimeBounds() + ")";
    }

    @Generated
    public static class TransactionPreconditionsBuilder {
        @Generated
        private LedgerBounds ledgerBounds;
        @Generated
        private Long minSeqNumber;
        @Generated
        private boolean minSeqAge$set;
        @Generated
        private BigInteger minSeqAge$value;
        @Generated
        private long minSeqLedgerGap;
        @Generated
        private ArrayList<SignerKey> extraSigners;
        @Generated
        private TimeBounds timeBounds;

        @Generated
        TransactionPreconditionsBuilder() {
        }

        @Generated
        public TransactionPreconditionsBuilder ledgerBounds(LedgerBounds ledgerBounds) {
            this.ledgerBounds = ledgerBounds;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder minSeqNumber(Long minSeqNumber) {
            this.minSeqNumber = minSeqNumber;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder minSeqAge(BigInteger minSeqAge) {
            this.minSeqAge$value = minSeqAge;
            this.minSeqAge$set = true;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder minSeqLedgerGap(long minSeqLedgerGap) {
            this.minSeqLedgerGap = minSeqLedgerGap;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder extraSigner(SignerKey extraSigner) {
            if (this.extraSigners == null) {
                this.extraSigners = new ArrayList();
            }
            this.extraSigners.add(extraSigner);
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder extraSigners(Collection<? extends SignerKey> extraSigners) {
            if (extraSigners == null) {
                throw new NullPointerException("extraSigners cannot be null");
            }
            if (this.extraSigners == null) {
                this.extraSigners = new ArrayList();
            }
            this.extraSigners.addAll(extraSigners);
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder clearExtraSigners() {
            if (this.extraSigners != null) {
                this.extraSigners.clear();
            }
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        @Generated
        public TransactionPreconditions build() {
            List<SignerKey> extraSigners;
            switch (this.extraSigners == null ? 0 : this.extraSigners.size()) {
                case 0: {
                    extraSigners = Collections.emptyList();
                    break;
                }
                case 1: {
                    extraSigners = Collections.singletonList(this.extraSigners.get(0));
                    break;
                }
                default: {
                    extraSigners = Collections.unmodifiableList(new ArrayList<SignerKey>(this.extraSigners));
                }
            }
            BigInteger minSeqAge$value = this.minSeqAge$value;
            if (!this.minSeqAge$set) {
                minSeqAge$value = TransactionPreconditions.$default$minSeqAge();
            }
            return new TransactionPreconditions(this.ledgerBounds, this.minSeqNumber, minSeqAge$value, this.minSeqLedgerGap, extraSigners, this.timeBounds);
        }

        @Generated
        public String toString() {
            return "TransactionPreconditions.TransactionPreconditionsBuilder(ledgerBounds=" + this.ledgerBounds + ", minSeqNumber=" + this.minSeqNumber + ", minSeqAge$value=" + this.minSeqAge$value + ", minSeqLedgerGap=" + this.minSeqLedgerGap + ", extraSigners=" + this.extraSigners + ", timeBounds=" + this.timeBounds + ")";
        }
    }
}

