/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AllowTrustResultCode implements XdrElement
{
    ALLOW_TRUST_SUCCESS(0),
    ALLOW_TRUST_MALFORMED(-1),
    ALLOW_TRUST_NO_TRUST_LINE(-2),
    ALLOW_TRUST_TRUST_NOT_REQUIRED(-3),
    ALLOW_TRUST_CANT_REVOKE(-4),
    ALLOW_TRUST_SELF_NOT_ALLOWED(-5),
    ALLOW_TRUST_LOW_RESERVE(-6);

    private int mValue;

    private AllowTrustResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static AllowTrustResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ALLOW_TRUST_SUCCESS;
            }
            case -1: {
                return ALLOW_TRUST_MALFORMED;
            }
            case -2: {
                return ALLOW_TRUST_NO_TRUST_LINE;
            }
            case -3: {
                return ALLOW_TRUST_TRUST_NOT_REQUIRED;
            }
            case -4: {
                return ALLOW_TRUST_CANT_REVOKE;
            }
            case -5: {
                return ALLOW_TRUST_SELF_NOT_ALLOWED;
            }
            case -6: {
                return ALLOW_TRUST_LOW_RESERVE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, AllowTrustResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AllowTrustResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AllowTrustResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AllowTrustResultCode.fromXdrByteArray(bytes);
    }

    public static AllowTrustResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AllowTrustResultCode.decode(xdrDataInputStream);
    }
}

