/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseMetaExtV1
implements XdrElement {
    private ExtensionPoint ext;
    private Int64 sorobanFeeWrite1KB;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public Int64 getSorobanFeeWrite1KB() {
        return this.sorobanFeeWrite1KB;
    }

    public void setSorobanFeeWrite1KB(Int64 value) {
        this.sorobanFeeWrite1KB = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerCloseMetaExtV1 encodedLedgerCloseMetaExtV1) throws IOException {
        ExtensionPoint.encode(stream, encodedLedgerCloseMetaExtV1.ext);
        Int64.encode(stream, encodedLedgerCloseMetaExtV1.sorobanFeeWrite1KB);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerCloseMetaExtV1.encode(stream, this);
    }

    public static LedgerCloseMetaExtV1 decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMetaExtV1 decodedLedgerCloseMetaExtV1 = new LedgerCloseMetaExtV1();
        decodedLedgerCloseMetaExtV1.ext = ExtensionPoint.decode(stream);
        decodedLedgerCloseMetaExtV1.sorobanFeeWrite1KB = Int64.decode(stream);
        return decodedLedgerCloseMetaExtV1;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.sorobanFeeWrite1KB);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerCloseMetaExtV1)) {
            return false;
        }
        LedgerCloseMetaExtV1 other = (LedgerCloseMetaExtV1)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.sorobanFeeWrite1KB, other.sorobanFeeWrite1KB);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerCloseMetaExtV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseMetaExtV1.fromXdrByteArray(bytes);
    }

    public static LedgerCloseMetaExtV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseMetaExtV1.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private Int64 sorobanFeeWrite1KB;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder sorobanFeeWrite1KB(Int64 sorobanFeeWrite1KB) {
            this.sorobanFeeWrite1KB = sorobanFeeWrite1KB;
            return this;
        }

        public LedgerCloseMetaExtV1 build() {
            LedgerCloseMetaExtV1 val = new LedgerCloseMetaExtV1();
            val.setExt(this.ext);
            val.setSorobanFeeWrite1KB(this.sorobanFeeWrite1KB);
            return val;
        }
    }
}

