/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerHeaderFlags implements XdrElement
{
    DISABLE_LIQUIDITY_POOL_TRADING_FLAG(1),
    DISABLE_LIQUIDITY_POOL_DEPOSIT_FLAG(2),
    DISABLE_LIQUIDITY_POOL_WITHDRAWAL_FLAG(4);

    private int mValue;

    private LedgerHeaderFlags(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LedgerHeaderFlags decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return DISABLE_LIQUIDITY_POOL_TRADING_FLAG;
            }
            case 2: {
                return DISABLE_LIQUIDITY_POOL_DEPOSIT_FLAG;
            }
            case 4: {
                return DISABLE_LIQUIDITY_POOL_WITHDRAWAL_FLAG;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LedgerHeaderFlags value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerHeaderFlags.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerHeaderFlags fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerHeaderFlags.fromXdrByteArray(bytes);
    }

    public static LedgerHeaderFlags fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerHeaderFlags.decode(xdrDataInputStream);
    }
}

