/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCSpecEntryKind implements XdrElement
{
    SC_SPEC_ENTRY_FUNCTION_V0(0),
    SC_SPEC_ENTRY_UDT_STRUCT_V0(1),
    SC_SPEC_ENTRY_UDT_UNION_V0(2),
    SC_SPEC_ENTRY_UDT_ENUM_V0(3),
    SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0(4);

    private int mValue;

    private SCSpecEntryKind(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SCSpecEntryKind decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SC_SPEC_ENTRY_FUNCTION_V0;
            }
            case 1: {
                return SC_SPEC_ENTRY_UDT_STRUCT_V0;
            }
            case 2: {
                return SC_SPEC_ENTRY_UDT_UNION_V0;
            }
            case 3: {
                return SC_SPEC_ENTRY_UDT_ENUM_V0;
            }
            case 4: {
                return SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SCSpecEntryKind value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecEntryKind.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecEntryKind fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecEntryKind.fromXdrByteArray(bytes);
    }

    public static SCSpecEntryKind fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecEntryKind.decode(xdrDataInputStream);
    }
}

