/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SetTrustLineFlagsResultCode implements XdrElement
{
    SET_TRUST_LINE_FLAGS_SUCCESS(0),
    SET_TRUST_LINE_FLAGS_MALFORMED(-1),
    SET_TRUST_LINE_FLAGS_NO_TRUST_LINE(-2),
    SET_TRUST_LINE_FLAGS_CANT_REVOKE(-3),
    SET_TRUST_LINE_FLAGS_INVALID_STATE(-4),
    SET_TRUST_LINE_FLAGS_LOW_RESERVE(-5);

    private int mValue;

    private SetTrustLineFlagsResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SetTrustLineFlagsResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SET_TRUST_LINE_FLAGS_SUCCESS;
            }
            case -1: {
                return SET_TRUST_LINE_FLAGS_MALFORMED;
            }
            case -2: {
                return SET_TRUST_LINE_FLAGS_NO_TRUST_LINE;
            }
            case -3: {
                return SET_TRUST_LINE_FLAGS_CANT_REVOKE;
            }
            case -4: {
                return SET_TRUST_LINE_FLAGS_INVALID_STATE;
            }
            case -5: {
                return SET_TRUST_LINE_FLAGS_LOW_RESERVE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SetTrustLineFlagsResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SetTrustLineFlagsResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SetTrustLineFlagsResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SetTrustLineFlagsResultCode.fromXdrByteArray(bytes);
    }

    public static SetTrustLineFlagsResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SetTrustLineFlagsResultCode.decode(xdrDataInputStream);
    }
}

