/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SorobanAuthorizedFunction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanAuthorizedInvocation
implements XdrElement {
    private SorobanAuthorizedFunction function;
    private SorobanAuthorizedInvocation[] subInvocations;

    public SorobanAuthorizedFunction getFunction() {
        return this.function;
    }

    public void setFunction(SorobanAuthorizedFunction value) {
        this.function = value;
    }

    public SorobanAuthorizedInvocation[] getSubInvocations() {
        return this.subInvocations;
    }

    public void setSubInvocations(SorobanAuthorizedInvocation[] value) {
        this.subInvocations = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanAuthorizedInvocation encodedSorobanAuthorizedInvocation) throws IOException {
        SorobanAuthorizedFunction.encode(stream, encodedSorobanAuthorizedInvocation.function);
        int subInvocationssize = encodedSorobanAuthorizedInvocation.getSubInvocations().length;
        stream.writeInt(subInvocationssize);
        for (int i = 0; i < subInvocationssize; ++i) {
            SorobanAuthorizedInvocation.encode(stream, encodedSorobanAuthorizedInvocation.subInvocations[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanAuthorizedInvocation.encode(stream, this);
    }

    public static SorobanAuthorizedInvocation decode(XdrDataInputStream stream) throws IOException {
        SorobanAuthorizedInvocation decodedSorobanAuthorizedInvocation = new SorobanAuthorizedInvocation();
        decodedSorobanAuthorizedInvocation.function = SorobanAuthorizedFunction.decode(stream);
        int subInvocationssize = stream.readInt();
        decodedSorobanAuthorizedInvocation.subInvocations = new SorobanAuthorizedInvocation[subInvocationssize];
        for (int i = 0; i < subInvocationssize; ++i) {
            decodedSorobanAuthorizedInvocation.subInvocations[i] = SorobanAuthorizedInvocation.decode(stream);
        }
        return decodedSorobanAuthorizedInvocation;
    }

    public int hashCode() {
        return Objects.hash(this.function, Arrays.hashCode(this.subInvocations));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanAuthorizedInvocation)) {
            return false;
        }
        SorobanAuthorizedInvocation other = (SorobanAuthorizedInvocation)object;
        return Objects.equals(this.function, other.function) && Arrays.equals(this.subInvocations, other.subInvocations);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanAuthorizedInvocation fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanAuthorizedInvocation.fromXdrByteArray(bytes);
    }

    public static SorobanAuthorizedInvocation fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanAuthorizedInvocation.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SorobanAuthorizedFunction function;
        private SorobanAuthorizedInvocation[] subInvocations;

        public Builder function(SorobanAuthorizedFunction function) {
            this.function = function;
            return this;
        }

        public Builder subInvocations(SorobanAuthorizedInvocation[] subInvocations) {
            this.subInvocations = subInvocations;
            return this;
        }

        public SorobanAuthorizedInvocation build() {
            SorobanAuthorizedInvocation val = new SorobanAuthorizedInvocation();
            val.setFunction(this.function);
            val.setSubInvocations(this.subInvocations);
            return val;
        }
    }
}

