// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  union ChangeTrustAsset switch (AssetType type)
//  {
//  case ASSET_TYPE_NATIVE: // Not credit
//      void;
//
//  case ASSET_TYPE_CREDIT_ALPHANUM4:
//      AlphaNum4 alphaNum4;
//
//  case ASSET_TYPE_CREDIT_ALPHANUM12:
//      AlphaNum12 alphaNum12;
//
//  case ASSET_TYPE_POOL_SHARE:
//      LiquidityPoolParameters liquidityPool;
//
//      // add other asset types here in the future
//  };

//  ===========================================================================
public class ChangeTrustAsset implements XdrElement {
  public ChangeTrustAsset() {}

  AssetType type;

  public AssetType getDiscriminant() {
    return this.type;
  }

  public void setDiscriminant(AssetType value) {
    this.type = value;
  }

  private AlphaNum4 alphaNum4;

  public AlphaNum4 getAlphaNum4() {
    return this.alphaNum4;
  }

  public void setAlphaNum4(AlphaNum4 value) {
    this.alphaNum4 = value;
  }

  private AlphaNum12 alphaNum12;

  public AlphaNum12 getAlphaNum12() {
    return this.alphaNum12;
  }

  public void setAlphaNum12(AlphaNum12 value) {
    this.alphaNum12 = value;
  }

  private LiquidityPoolParameters liquidityPool;

  public LiquidityPoolParameters getLiquidityPool() {
    return this.liquidityPool;
  }

  public void setLiquidityPool(LiquidityPoolParameters value) {
    this.liquidityPool = value;
  }

  public static final class Builder {
    private AssetType discriminant;
    private AlphaNum4 alphaNum4;
    private AlphaNum12 alphaNum12;
    private LiquidityPoolParameters liquidityPool;

    public Builder discriminant(AssetType discriminant) {
      this.discriminant = discriminant;
      return this;
    }

    public Builder alphaNum4(AlphaNum4 alphaNum4) {
      this.alphaNum4 = alphaNum4;
      return this;
    }

    public Builder alphaNum12(AlphaNum12 alphaNum12) {
      this.alphaNum12 = alphaNum12;
      return this;
    }

    public Builder liquidityPool(LiquidityPoolParameters liquidityPool) {
      this.liquidityPool = liquidityPool;
      return this;
    }

    public ChangeTrustAsset build() {
      ChangeTrustAsset val = new ChangeTrustAsset();
      val.setDiscriminant(discriminant);
      val.setAlphaNum4(this.alphaNum4);
      val.setAlphaNum12(this.alphaNum12);
      val.setLiquidityPool(this.liquidityPool);
      return val;
    }
  }

  public static void encode(XdrDataOutputStream stream, ChangeTrustAsset encodedChangeTrustAsset)
      throws IOException {
    // Xdrgen::AST::Identifier
    // AssetType
    stream.writeInt(encodedChangeTrustAsset.getDiscriminant().getValue());
    switch (encodedChangeTrustAsset.getDiscriminant()) {
      case ASSET_TYPE_NATIVE:
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        AlphaNum4.encode(stream, encodedChangeTrustAsset.alphaNum4);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        AlphaNum12.encode(stream, encodedChangeTrustAsset.alphaNum12);
        break;
      case ASSET_TYPE_POOL_SHARE:
        LiquidityPoolParameters.encode(stream, encodedChangeTrustAsset.liquidityPool);
        break;
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static ChangeTrustAsset decode(XdrDataInputStream stream) throws IOException {
    ChangeTrustAsset decodedChangeTrustAsset = new ChangeTrustAsset();
    AssetType discriminant = AssetType.decode(stream);
    decodedChangeTrustAsset.setDiscriminant(discriminant);
    switch (decodedChangeTrustAsset.getDiscriminant()) {
      case ASSET_TYPE_NATIVE:
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        decodedChangeTrustAsset.alphaNum4 = AlphaNum4.decode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        decodedChangeTrustAsset.alphaNum12 = AlphaNum12.decode(stream);
        break;
      case ASSET_TYPE_POOL_SHARE:
        decodedChangeTrustAsset.liquidityPool = LiquidityPoolParameters.decode(stream);
        break;
    }
    return decodedChangeTrustAsset;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.alphaNum4, this.alphaNum12, this.liquidityPool, this.type);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof ChangeTrustAsset)) {
      return false;
    }

    ChangeTrustAsset other = (ChangeTrustAsset) object;
    return Objects.equals(this.alphaNum4, other.alphaNum4)
        && Objects.equals(this.alphaNum12, other.alphaNum12)
        && Objects.equals(this.liquidityPool, other.liquidityPool)
        && Objects.equals(this.type, other.type);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static ChangeTrustAsset fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ChangeTrustAsset fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
