// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct LedgerEntry
//  {
//      uint32 lastModifiedLedgerSeq; // ledger the LedgerEntry was last changed
//
//      union switch (LedgerEntryType type)
//      {
//      case ACCOUNT:
//          AccountEntry account;
//      case TRUSTLINE:
//          TrustLineEntry trustLine;
//      case OFFER:
//          OfferEntry offer;
//      case DATA:
//          DataEntry data;
//      case CLAIMABLE_BALANCE:
//          ClaimableBalanceEntry claimableBalance;
//      case LIQUIDITY_POOL:
//          LiquidityPoolEntry liquidityPool;
//      case CONTRACT_DATA:
//          ContractDataEntry contractData;
//      case CONTRACT_CODE:
//          ContractCodeEntry contractCode;
//      case CONFIG_SETTING:
//          ConfigSettingEntry configSetting;
//      case TTL:
//          TTLEntry ttl;
//      }
//      data;
//
//      // reserved for future use
//      union switch (int v)
//      {
//      case 0:
//          void;
//      case 1:
//          LedgerEntryExtensionV1 v1;
//      }
//      ext;
//  };

//  ===========================================================================
public class LedgerEntry implements XdrElement {
  public LedgerEntry() {}

  private Uint32 lastModifiedLedgerSeq;

  public Uint32 getLastModifiedLedgerSeq() {
    return this.lastModifiedLedgerSeq;
  }

  public void setLastModifiedLedgerSeq(Uint32 value) {
    this.lastModifiedLedgerSeq = value;
  }

  private LedgerEntryData data;

  public LedgerEntryData getData() {
    return this.data;
  }

  public void setData(LedgerEntryData value) {
    this.data = value;
  }

  private LedgerEntryExt ext;

  public LedgerEntryExt getExt() {
    return this.ext;
  }

  public void setExt(LedgerEntryExt value) {
    this.ext = value;
  }

  public static void encode(XdrDataOutputStream stream, LedgerEntry encodedLedgerEntry)
      throws IOException {
    Uint32.encode(stream, encodedLedgerEntry.lastModifiedLedgerSeq);
    LedgerEntryData.encode(stream, encodedLedgerEntry.data);
    LedgerEntryExt.encode(stream, encodedLedgerEntry.ext);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static LedgerEntry decode(XdrDataInputStream stream) throws IOException {
    LedgerEntry decodedLedgerEntry = new LedgerEntry();
    decodedLedgerEntry.lastModifiedLedgerSeq = Uint32.decode(stream);
    decodedLedgerEntry.data = LedgerEntryData.decode(stream);
    decodedLedgerEntry.ext = LedgerEntryExt.decode(stream);
    return decodedLedgerEntry;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.lastModifiedLedgerSeq, this.data, this.ext);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof LedgerEntry)) {
      return false;
    }

    LedgerEntry other = (LedgerEntry) object;
    return Objects.equals(this.lastModifiedLedgerSeq, other.lastModifiedLedgerSeq)
        && Objects.equals(this.data, other.data)
        && Objects.equals(this.ext, other.ext);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static LedgerEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Uint32 lastModifiedLedgerSeq;
    private LedgerEntryData data;
    private LedgerEntryExt ext;

    public Builder lastModifiedLedgerSeq(Uint32 lastModifiedLedgerSeq) {
      this.lastModifiedLedgerSeq = lastModifiedLedgerSeq;
      return this;
    }

    public Builder data(LedgerEntryData data) {
      this.data = data;
      return this;
    }

    public Builder ext(LedgerEntryExt ext) {
      this.ext = ext;
      return this;
    }

    public LedgerEntry build() {
      LedgerEntry val = new LedgerEntry();
      val.setLastModifiedLedgerSeq(this.lastModifiedLedgerSeq);
      val.setData(this.data);
      val.setExt(this.ext);
      return val;
    }
  }

  public static class LedgerEntryData implements XdrElement {
    public LedgerEntryData() {}

    LedgerEntryType type;

    public LedgerEntryType getDiscriminant() {
      return this.type;
    }

    public void setDiscriminant(LedgerEntryType value) {
      this.type = value;
    }

    private AccountEntry account;

    public AccountEntry getAccount() {
      return this.account;
    }

    public void setAccount(AccountEntry value) {
      this.account = value;
    }

    private TrustLineEntry trustLine;

    public TrustLineEntry getTrustLine() {
      return this.trustLine;
    }

    public void setTrustLine(TrustLineEntry value) {
      this.trustLine = value;
    }

    private OfferEntry offer;

    public OfferEntry getOffer() {
      return this.offer;
    }

    public void setOffer(OfferEntry value) {
      this.offer = value;
    }

    private DataEntry data;

    public DataEntry getData() {
      return this.data;
    }

    public void setData(DataEntry value) {
      this.data = value;
    }

    private ClaimableBalanceEntry claimableBalance;

    public ClaimableBalanceEntry getClaimableBalance() {
      return this.claimableBalance;
    }

    public void setClaimableBalance(ClaimableBalanceEntry value) {
      this.claimableBalance = value;
    }

    private LiquidityPoolEntry liquidityPool;

    public LiquidityPoolEntry getLiquidityPool() {
      return this.liquidityPool;
    }

    public void setLiquidityPool(LiquidityPoolEntry value) {
      this.liquidityPool = value;
    }

    private ContractDataEntry contractData;

    public ContractDataEntry getContractData() {
      return this.contractData;
    }

    public void setContractData(ContractDataEntry value) {
      this.contractData = value;
    }

    private ContractCodeEntry contractCode;

    public ContractCodeEntry getContractCode() {
      return this.contractCode;
    }

    public void setContractCode(ContractCodeEntry value) {
      this.contractCode = value;
    }

    private ConfigSettingEntry configSetting;

    public ConfigSettingEntry getConfigSetting() {
      return this.configSetting;
    }

    public void setConfigSetting(ConfigSettingEntry value) {
      this.configSetting = value;
    }

    private TTLEntry ttl;

    public TTLEntry getTtl() {
      return this.ttl;
    }

    public void setTtl(TTLEntry value) {
      this.ttl = value;
    }

    public static final class Builder {
      private LedgerEntryType discriminant;
      private AccountEntry account;
      private TrustLineEntry trustLine;
      private OfferEntry offer;
      private DataEntry data;
      private ClaimableBalanceEntry claimableBalance;
      private LiquidityPoolEntry liquidityPool;
      private ContractDataEntry contractData;
      private ContractCodeEntry contractCode;
      private ConfigSettingEntry configSetting;
      private TTLEntry ttl;

      public Builder discriminant(LedgerEntryType discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder account(AccountEntry account) {
        this.account = account;
        return this;
      }

      public Builder trustLine(TrustLineEntry trustLine) {
        this.trustLine = trustLine;
        return this;
      }

      public Builder offer(OfferEntry offer) {
        this.offer = offer;
        return this;
      }

      public Builder data(DataEntry data) {
        this.data = data;
        return this;
      }

      public Builder claimableBalance(ClaimableBalanceEntry claimableBalance) {
        this.claimableBalance = claimableBalance;
        return this;
      }

      public Builder liquidityPool(LiquidityPoolEntry liquidityPool) {
        this.liquidityPool = liquidityPool;
        return this;
      }

      public Builder contractData(ContractDataEntry contractData) {
        this.contractData = contractData;
        return this;
      }

      public Builder contractCode(ContractCodeEntry contractCode) {
        this.contractCode = contractCode;
        return this;
      }

      public Builder configSetting(ConfigSettingEntry configSetting) {
        this.configSetting = configSetting;
        return this;
      }

      public Builder ttl(TTLEntry ttl) {
        this.ttl = ttl;
        return this;
      }

      public LedgerEntryData build() {
        LedgerEntryData val = new LedgerEntryData();
        val.setDiscriminant(discriminant);
        val.setAccount(this.account);
        val.setTrustLine(this.trustLine);
        val.setOffer(this.offer);
        val.setData(this.data);
        val.setClaimableBalance(this.claimableBalance);
        val.setLiquidityPool(this.liquidityPool);
        val.setContractData(this.contractData);
        val.setContractCode(this.contractCode);
        val.setConfigSetting(this.configSetting);
        val.setTtl(this.ttl);
        return val;
      }
    }

    public static void encode(XdrDataOutputStream stream, LedgerEntryData encodedLedgerEntryData)
        throws IOException {
      // Xdrgen::AST::Identifier
      // LedgerEntryType
      stream.writeInt(encodedLedgerEntryData.getDiscriminant().getValue());
      switch (encodedLedgerEntryData.getDiscriminant()) {
        case ACCOUNT:
          AccountEntry.encode(stream, encodedLedgerEntryData.account);
          break;
        case TRUSTLINE:
          TrustLineEntry.encode(stream, encodedLedgerEntryData.trustLine);
          break;
        case OFFER:
          OfferEntry.encode(stream, encodedLedgerEntryData.offer);
          break;
        case DATA:
          DataEntry.encode(stream, encodedLedgerEntryData.data);
          break;
        case CLAIMABLE_BALANCE:
          ClaimableBalanceEntry.encode(stream, encodedLedgerEntryData.claimableBalance);
          break;
        case LIQUIDITY_POOL:
          LiquidityPoolEntry.encode(stream, encodedLedgerEntryData.liquidityPool);
          break;
        case CONTRACT_DATA:
          ContractDataEntry.encode(stream, encodedLedgerEntryData.contractData);
          break;
        case CONTRACT_CODE:
          ContractCodeEntry.encode(stream, encodedLedgerEntryData.contractCode);
          break;
        case CONFIG_SETTING:
          ConfigSettingEntry.encode(stream, encodedLedgerEntryData.configSetting);
          break;
        case TTL:
          TTLEntry.encode(stream, encodedLedgerEntryData.ttl);
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerEntryData decode(XdrDataInputStream stream) throws IOException {
      LedgerEntryData decodedLedgerEntryData = new LedgerEntryData();
      LedgerEntryType discriminant = LedgerEntryType.decode(stream);
      decodedLedgerEntryData.setDiscriminant(discriminant);
      switch (decodedLedgerEntryData.getDiscriminant()) {
        case ACCOUNT:
          decodedLedgerEntryData.account = AccountEntry.decode(stream);
          break;
        case TRUSTLINE:
          decodedLedgerEntryData.trustLine = TrustLineEntry.decode(stream);
          break;
        case OFFER:
          decodedLedgerEntryData.offer = OfferEntry.decode(stream);
          break;
        case DATA:
          decodedLedgerEntryData.data = DataEntry.decode(stream);
          break;
        case CLAIMABLE_BALANCE:
          decodedLedgerEntryData.claimableBalance = ClaimableBalanceEntry.decode(stream);
          break;
        case LIQUIDITY_POOL:
          decodedLedgerEntryData.liquidityPool = LiquidityPoolEntry.decode(stream);
          break;
        case CONTRACT_DATA:
          decodedLedgerEntryData.contractData = ContractDataEntry.decode(stream);
          break;
        case CONTRACT_CODE:
          decodedLedgerEntryData.contractCode = ContractCodeEntry.decode(stream);
          break;
        case CONFIG_SETTING:
          decodedLedgerEntryData.configSetting = ConfigSettingEntry.decode(stream);
          break;
        case TTL:
          decodedLedgerEntryData.ttl = TTLEntry.decode(stream);
          break;
      }
      return decodedLedgerEntryData;
    }

    @Override
    public int hashCode() {
      return Objects.hash(
          this.account,
          this.trustLine,
          this.offer,
          this.data,
          this.claimableBalance,
          this.liquidityPool,
          this.contractData,
          this.contractCode,
          this.configSetting,
          this.ttl,
          this.type);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerEntryData)) {
        return false;
      }

      LedgerEntryData other = (LedgerEntryData) object;
      return Objects.equals(this.account, other.account)
          && Objects.equals(this.trustLine, other.trustLine)
          && Objects.equals(this.offer, other.offer)
          && Objects.equals(this.data, other.data)
          && Objects.equals(this.claimableBalance, other.claimableBalance)
          && Objects.equals(this.liquidityPool, other.liquidityPool)
          && Objects.equals(this.contractData, other.contractData)
          && Objects.equals(this.contractCode, other.contractCode)
          && Objects.equals(this.configSetting, other.configSetting)
          && Objects.equals(this.ttl, other.ttl)
          && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerEntryData fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerEntryData fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  public static class LedgerEntryExt implements XdrElement {
    public LedgerEntryExt() {}

    Integer v;

    public Integer getDiscriminant() {
      return this.v;
    }

    public void setDiscriminant(Integer value) {
      this.v = value;
    }

    private LedgerEntryExtensionV1 v1;

    public LedgerEntryExtensionV1 getV1() {
      return this.v1;
    }

    public void setV1(LedgerEntryExtensionV1 value) {
      this.v1 = value;
    }

    public static final class Builder {
      private Integer discriminant;
      private LedgerEntryExtensionV1 v1;

      public Builder discriminant(Integer discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder v1(LedgerEntryExtensionV1 v1) {
        this.v1 = v1;
        return this;
      }

      public LedgerEntryExt build() {
        LedgerEntryExt val = new LedgerEntryExt();
        val.setDiscriminant(discriminant);
        val.setV1(this.v1);
        return val;
      }
    }

    public static void encode(XdrDataOutputStream stream, LedgerEntryExt encodedLedgerEntryExt)
        throws IOException {
      // Xdrgen::AST::Typespecs::Int
      // Integer
      stream.writeInt(encodedLedgerEntryExt.getDiscriminant().intValue());
      switch (encodedLedgerEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          LedgerEntryExtensionV1.encode(stream, encodedLedgerEntryExt.v1);
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static LedgerEntryExt decode(XdrDataInputStream stream) throws IOException {
      LedgerEntryExt decodedLedgerEntryExt = new LedgerEntryExt();
      Integer discriminant = stream.readInt();
      decodedLedgerEntryExt.setDiscriminant(discriminant);
      switch (decodedLedgerEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedLedgerEntryExt.v1 = LedgerEntryExtensionV1.decode(stream);
          break;
      }
      return decodedLedgerEntryExt;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.v1, this.v);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof LedgerEntryExt)) {
        return false;
      }

      LedgerEntryExt other = (LedgerEntryExt) object;
      return Objects.equals(this.v1, other.v1) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static LedgerEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
