// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  union MuxedAccount switch (CryptoKeyType type)
//  {
//  case KEY_TYPE_ED25519:
//      uint256 ed25519;
//  case KEY_TYPE_MUXED_ED25519:
//      struct
//      {
//          uint64 id;
//          uint256 ed25519;
//      } med25519;
//  };

//  ===========================================================================
public class MuxedAccount implements XdrElement {
  public MuxedAccount() {}

  CryptoKeyType type;

  public CryptoKeyType getDiscriminant() {
    return this.type;
  }

  public void setDiscriminant(CryptoKeyType value) {
    this.type = value;
  }

  private Uint256 ed25519;

  public Uint256 getEd25519() {
    return this.ed25519;
  }

  public void setEd25519(Uint256 value) {
    this.ed25519 = value;
  }

  private MuxedAccountMed25519 med25519;

  public MuxedAccountMed25519 getMed25519() {
    return this.med25519;
  }

  public void setMed25519(MuxedAccountMed25519 value) {
    this.med25519 = value;
  }

  public static final class Builder {
    private CryptoKeyType discriminant;
    private Uint256 ed25519;
    private MuxedAccountMed25519 med25519;

    public Builder discriminant(CryptoKeyType discriminant) {
      this.discriminant = discriminant;
      return this;
    }

    public Builder ed25519(Uint256 ed25519) {
      this.ed25519 = ed25519;
      return this;
    }

    public Builder med25519(MuxedAccountMed25519 med25519) {
      this.med25519 = med25519;
      return this;
    }

    public MuxedAccount build() {
      MuxedAccount val = new MuxedAccount();
      val.setDiscriminant(discriminant);
      val.setEd25519(this.ed25519);
      val.setMed25519(this.med25519);
      return val;
    }
  }

  public static void encode(XdrDataOutputStream stream, MuxedAccount encodedMuxedAccount)
      throws IOException {
    // Xdrgen::AST::Identifier
    // CryptoKeyType
    stream.writeInt(encodedMuxedAccount.getDiscriminant().getValue());
    switch (encodedMuxedAccount.getDiscriminant()) {
      case KEY_TYPE_ED25519:
        Uint256.encode(stream, encodedMuxedAccount.ed25519);
        break;
      case KEY_TYPE_MUXED_ED25519:
        MuxedAccountMed25519.encode(stream, encodedMuxedAccount.med25519);
        break;
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static MuxedAccount decode(XdrDataInputStream stream) throws IOException {
    MuxedAccount decodedMuxedAccount = new MuxedAccount();
    CryptoKeyType discriminant = CryptoKeyType.decode(stream);
    decodedMuxedAccount.setDiscriminant(discriminant);
    switch (decodedMuxedAccount.getDiscriminant()) {
      case KEY_TYPE_ED25519:
        decodedMuxedAccount.ed25519 = Uint256.decode(stream);
        break;
      case KEY_TYPE_MUXED_ED25519:
        decodedMuxedAccount.med25519 = MuxedAccountMed25519.decode(stream);
        break;
    }
    return decodedMuxedAccount;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.ed25519, this.med25519, this.type);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof MuxedAccount)) {
      return false;
    }

    MuxedAccount other = (MuxedAccount) object;
    return Objects.equals(this.ed25519, other.ed25519)
        && Objects.equals(this.med25519, other.med25519)
        && Objects.equals(this.type, other.type);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static MuxedAccount fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static MuxedAccount fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static class MuxedAccountMed25519 implements XdrElement {
    public MuxedAccountMed25519() {}

    private Uint64 id;

    public Uint64 getId() {
      return this.id;
    }

    public void setId(Uint64 value) {
      this.id = value;
    }

    private Uint256 ed25519;

    public Uint256 getEd25519() {
      return this.ed25519;
    }

    public void setEd25519(Uint256 value) {
      this.ed25519 = value;
    }

    public static void encode(
        XdrDataOutputStream stream, MuxedAccountMed25519 encodedMuxedAccountMed25519)
        throws IOException {
      Uint64.encode(stream, encodedMuxedAccountMed25519.id);
      Uint256.encode(stream, encodedMuxedAccountMed25519.ed25519);
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static MuxedAccountMed25519 decode(XdrDataInputStream stream) throws IOException {
      MuxedAccountMed25519 decodedMuxedAccountMed25519 = new MuxedAccountMed25519();
      decodedMuxedAccountMed25519.id = Uint64.decode(stream);
      decodedMuxedAccountMed25519.ed25519 = Uint256.decode(stream);
      return decodedMuxedAccountMed25519;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.id, this.ed25519);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof MuxedAccountMed25519)) {
        return false;
      }

      MuxedAccountMed25519 other = (MuxedAccountMed25519) object;
      return Objects.equals(this.id, other.id) && Objects.equals(this.ed25519, other.ed25519);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static MuxedAccountMed25519 fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static MuxedAccountMed25519 fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    public static final class Builder {
      private Uint64 id;
      private Uint256 ed25519;

      public Builder id(Uint64 id) {
        this.id = id;
        return this;
      }

      public Builder ed25519(Uint256 ed25519) {
        this.ed25519 = ed25519;
        return this;
      }

      public MuxedAccountMed25519 build() {
        MuxedAccountMed25519 val = new MuxedAccountMed25519();
        val.setId(this.id);
        val.setEd25519(this.ed25519);
        return val;
      }
    }
  }
}
