// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  union TransactionMeta switch (int v)
//  {
//  case 0:
//      OperationMeta operations<>;
//  case 1:
//      TransactionMetaV1 v1;
//  case 2:
//      TransactionMetaV2 v2;
//  case 3:
//      TransactionMetaV3 v3;
//  };

//  ===========================================================================
public class TransactionMeta implements XdrElement {
  public TransactionMeta() {}

  Integer v;

  public Integer getDiscriminant() {
    return this.v;
  }

  public void setDiscriminant(Integer value) {
    this.v = value;
  }

  private OperationMeta[] operations;

  public OperationMeta[] getOperations() {
    return this.operations;
  }

  public void setOperations(OperationMeta[] value) {
    this.operations = value;
  }

  private TransactionMetaV1 v1;

  public TransactionMetaV1 getV1() {
    return this.v1;
  }

  public void setV1(TransactionMetaV1 value) {
    this.v1 = value;
  }

  private TransactionMetaV2 v2;

  public TransactionMetaV2 getV2() {
    return this.v2;
  }

  public void setV2(TransactionMetaV2 value) {
    this.v2 = value;
  }

  private TransactionMetaV3 v3;

  public TransactionMetaV3 getV3() {
    return this.v3;
  }

  public void setV3(TransactionMetaV3 value) {
    this.v3 = value;
  }

  public static final class Builder {
    private Integer discriminant;
    private OperationMeta[] operations;
    private TransactionMetaV1 v1;
    private TransactionMetaV2 v2;
    private TransactionMetaV3 v3;

    public Builder discriminant(Integer discriminant) {
      this.discriminant = discriminant;
      return this;
    }

    public Builder operations(OperationMeta[] operations) {
      this.operations = operations;
      return this;
    }

    public Builder v1(TransactionMetaV1 v1) {
      this.v1 = v1;
      return this;
    }

    public Builder v2(TransactionMetaV2 v2) {
      this.v2 = v2;
      return this;
    }

    public Builder v3(TransactionMetaV3 v3) {
      this.v3 = v3;
      return this;
    }

    public TransactionMeta build() {
      TransactionMeta val = new TransactionMeta();
      val.setDiscriminant(discriminant);
      val.setOperations(this.operations);
      val.setV1(this.v1);
      val.setV2(this.v2);
      val.setV3(this.v3);
      return val;
    }
  }

  public static void encode(XdrDataOutputStream stream, TransactionMeta encodedTransactionMeta)
      throws IOException {
    // Xdrgen::AST::Typespecs::Int
    // Integer
    stream.writeInt(encodedTransactionMeta.getDiscriminant().intValue());
    switch (encodedTransactionMeta.getDiscriminant()) {
      case 0:
        int operationssize = encodedTransactionMeta.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; i++) {
          OperationMeta.encode(stream, encodedTransactionMeta.operations[i]);
        }
        break;
      case 1:
        TransactionMetaV1.encode(stream, encodedTransactionMeta.v1);
        break;
      case 2:
        TransactionMetaV2.encode(stream, encodedTransactionMeta.v2);
        break;
      case 3:
        TransactionMetaV3.encode(stream, encodedTransactionMeta.v3);
        break;
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static TransactionMeta decode(XdrDataInputStream stream) throws IOException {
    TransactionMeta decodedTransactionMeta = new TransactionMeta();
    Integer discriminant = stream.readInt();
    decodedTransactionMeta.setDiscriminant(discriminant);
    switch (decodedTransactionMeta.getDiscriminant()) {
      case 0:
        int operationssize = stream.readInt();
        decodedTransactionMeta.operations = new OperationMeta[operationssize];
        for (int i = 0; i < operationssize; i++) {
          decodedTransactionMeta.operations[i] = OperationMeta.decode(stream);
        }
        break;
      case 1:
        decodedTransactionMeta.v1 = TransactionMetaV1.decode(stream);
        break;
      case 2:
        decodedTransactionMeta.v2 = TransactionMetaV2.decode(stream);
        break;
      case 3:
        decodedTransactionMeta.v3 = TransactionMetaV3.decode(stream);
        break;
    }
    return decodedTransactionMeta;
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(this.operations), this.v1, this.v2, this.v3, this.v);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof TransactionMeta)) {
      return false;
    }

    TransactionMeta other = (TransactionMeta) object;
    return Arrays.equals(this.operations, other.operations)
        && Objects.equals(this.v1, other.v1)
        && Objects.equals(this.v2, other.v2)
        && Objects.equals(this.v3, other.v3)
        && Objects.equals(this.v, other.v);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static TransactionMeta fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionMeta fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
