// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import static org.stellar.sdk.xdr.Constants.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;

// === xdr source ============================================================

//  struct TransactionSignaturePayload
//  {
//      Hash networkId;
//      union switch (EnvelopeType type)
//      {
//      // Backwards Compatibility: Use ENVELOPE_TYPE_TX to sign ENVELOPE_TYPE_TX_V0
//      case ENVELOPE_TYPE_TX:
//          Transaction tx;
//      case ENVELOPE_TYPE_TX_FEE_BUMP:
//          FeeBumpTransaction feeBump;
//      }
//      taggedTransaction;
//  };

//  ===========================================================================
public class TransactionSignaturePayload implements XdrElement {
  public TransactionSignaturePayload() {}

  private Hash networkId;

  public Hash getNetworkId() {
    return this.networkId;
  }

  public void setNetworkId(Hash value) {
    this.networkId = value;
  }

  private TransactionSignaturePayloadTaggedTransaction taggedTransaction;

  public TransactionSignaturePayloadTaggedTransaction getTaggedTransaction() {
    return this.taggedTransaction;
  }

  public void setTaggedTransaction(TransactionSignaturePayloadTaggedTransaction value) {
    this.taggedTransaction = value;
  }

  public static void encode(
      XdrDataOutputStream stream, TransactionSignaturePayload encodedTransactionSignaturePayload)
      throws IOException {
    Hash.encode(stream, encodedTransactionSignaturePayload.networkId);
    TransactionSignaturePayloadTaggedTransaction.encode(
        stream, encodedTransactionSignaturePayload.taggedTransaction);
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }

  public static TransactionSignaturePayload decode(XdrDataInputStream stream) throws IOException {
    TransactionSignaturePayload decodedTransactionSignaturePayload =
        new TransactionSignaturePayload();
    decodedTransactionSignaturePayload.networkId = Hash.decode(stream);
    decodedTransactionSignaturePayload.taggedTransaction =
        TransactionSignaturePayloadTaggedTransaction.decode(stream);
    return decodedTransactionSignaturePayload;
  }

  @Override
  public int hashCode() {
    return Objects.hash(this.networkId, this.taggedTransaction);
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof TransactionSignaturePayload)) {
      return false;
    }

    TransactionSignaturePayload other = (TransactionSignaturePayload) object;
    return Objects.equals(this.networkId, other.networkId)
        && Objects.equals(this.taggedTransaction, other.taggedTransaction);
  }

  @Override
  public String toXdrBase64() throws IOException {
    return Base64Factory.getInstance().encodeToString(toXdrByteArray());
  }

  @Override
  public byte[] toXdrByteArray() throws IOException {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
    encode(xdrDataOutputStream);
    return byteArrayOutputStream.toByteArray();
  }

  public static TransactionSignaturePayload fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionSignaturePayload fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  public static final class Builder {
    private Hash networkId;
    private TransactionSignaturePayloadTaggedTransaction taggedTransaction;

    public Builder networkId(Hash networkId) {
      this.networkId = networkId;
      return this;
    }

    public Builder taggedTransaction(
        TransactionSignaturePayloadTaggedTransaction taggedTransaction) {
      this.taggedTransaction = taggedTransaction;
      return this;
    }

    public TransactionSignaturePayload build() {
      TransactionSignaturePayload val = new TransactionSignaturePayload();
      val.setNetworkId(this.networkId);
      val.setTaggedTransaction(this.taggedTransaction);
      return val;
    }
  }

  public static class TransactionSignaturePayloadTaggedTransaction implements XdrElement {
    public TransactionSignaturePayloadTaggedTransaction() {}

    EnvelopeType type;

    public EnvelopeType getDiscriminant() {
      return this.type;
    }

    public void setDiscriminant(EnvelopeType value) {
      this.type = value;
    }

    private Transaction tx;

    public Transaction getTx() {
      return this.tx;
    }

    public void setTx(Transaction value) {
      this.tx = value;
    }

    private FeeBumpTransaction feeBump;

    public FeeBumpTransaction getFeeBump() {
      return this.feeBump;
    }

    public void setFeeBump(FeeBumpTransaction value) {
      this.feeBump = value;
    }

    public static final class Builder {
      private EnvelopeType discriminant;
      private Transaction tx;
      private FeeBumpTransaction feeBump;

      public Builder discriminant(EnvelopeType discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder tx(Transaction tx) {
        this.tx = tx;
        return this;
      }

      public Builder feeBump(FeeBumpTransaction feeBump) {
        this.feeBump = feeBump;
        return this;
      }

      public TransactionSignaturePayloadTaggedTransaction build() {
        TransactionSignaturePayloadTaggedTransaction val =
            new TransactionSignaturePayloadTaggedTransaction();
        val.setDiscriminant(discriminant);
        val.setTx(this.tx);
        val.setFeeBump(this.feeBump);
        return val;
      }
    }

    public static void encode(
        XdrDataOutputStream stream,
        TransactionSignaturePayloadTaggedTransaction
            encodedTransactionSignaturePayloadTaggedTransaction)
        throws IOException {
      // Xdrgen::AST::Identifier
      // EnvelopeType
      stream.writeInt(
          encodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant().getValue());
      switch (encodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant()) {
        case ENVELOPE_TYPE_TX:
          Transaction.encode(stream, encodedTransactionSignaturePayloadTaggedTransaction.tx);
          break;
        case ENVELOPE_TYPE_TX_FEE_BUMP:
          FeeBumpTransaction.encode(
              stream, encodedTransactionSignaturePayloadTaggedTransaction.feeBump);
          break;
      }
    }

    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }

    public static TransactionSignaturePayloadTaggedTransaction decode(XdrDataInputStream stream)
        throws IOException {
      TransactionSignaturePayloadTaggedTransaction
          decodedTransactionSignaturePayloadTaggedTransaction =
              new TransactionSignaturePayloadTaggedTransaction();
      EnvelopeType discriminant = EnvelopeType.decode(stream);
      decodedTransactionSignaturePayloadTaggedTransaction.setDiscriminant(discriminant);
      switch (decodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant()) {
        case ENVELOPE_TYPE_TX:
          decodedTransactionSignaturePayloadTaggedTransaction.tx = Transaction.decode(stream);
          break;
        case ENVELOPE_TYPE_TX_FEE_BUMP:
          decodedTransactionSignaturePayloadTaggedTransaction.feeBump =
              FeeBumpTransaction.decode(stream);
          break;
      }
      return decodedTransactionSignaturePayloadTaggedTransaction;
    }

    @Override
    public int hashCode() {
      return Objects.hash(this.tx, this.feeBump, this.type);
    }

    @Override
    public boolean equals(Object object) {
      if (!(object instanceof TransactionSignaturePayloadTaggedTransaction)) {
        return false;
      }

      TransactionSignaturePayloadTaggedTransaction other =
          (TransactionSignaturePayloadTaggedTransaction) object;
      return Objects.equals(this.tx, other.tx)
          && Objects.equals(this.feeBump, other.feeBump)
          && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
      return Base64Factory.getInstance().encodeToString(toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
      ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
      XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
      encode(xdrDataOutputStream);
      return byteArrayOutputStream.toByteArray();
    }

    public static TransactionSignaturePayloadTaggedTransaction fromXdrBase64(String xdr)
        throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionSignaturePayloadTaggedTransaction fromXdrByteArray(byte[] xdr)
        throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
